(function($) {

    var isOld = false;

    var MacroJsOverride = function() {
    };

    MacroJsOverride.prototype.getMacroDetailsFromSelectedMacro = function() {
        isOld = true;
    };

    MacroJsOverride.prototype.beforeParamsRetrieved = function(params) {

        params = UserMacroAutoComplete.collectParticipantParams(params);

        var columns = [];
        var columnsInput = $('#macro-param-columns');
        columnsInput.parent().find('.checkbox:checked').each(function () {
            columns.push($(this).data('column'));
        });
        params["columns"] = columns.join(',');

        return params;
    };

    MacroJsOverride.prototype.beforeParamsSet = function(params) {
        var exportInput = $('#macro-param-export');

        if (isOld && !params['v'] && !params['quizzes'] && $('#wysiwygTextarea_ifr').contents().find('[data-macro-name="quiz-settings"]').length === 1) {
            params['quizzes'] = QuizCommons.getContentId();
        }

        if (isOld && params['v'] != 3 && params['quizzes'] == QuizCommons.getContentId() && !params['show-answers']) {
            params['export'] = true;
            exportInput.prop('checked', true);
        }

        params['v'] = 3;
        isOld = false;
        params = QuizPagesMacroLib.init(params);

        var usersContainer = $('#macro-param-div-users');
        if ( $('#macro-param-div-quizzes').css('display') == 'none') {
            usersContainer.hide();
            $('#macro-param-div-show-answers, #macro-param-div-columns').hide();
            return params;
        }

        UserMacroAutoComplete.showUserCompletion(params);

        var columns = ['Participant', 'Attempts', 'Status', 'Result', 'Score', 'Date Started', 'Time Spent', 'Due Date', 'Shared By', 'Course'];
        if (params['columns']) {
            columns = params['columns'].split(',');
        }
        var columnsInput = $('#macro-param-columns');
        columnsInput.hide();
        var columnsWrapper = columnsInput.parent();

        var allColumns = [
            {value: 'Participant', label: AJS.I18n.getText('quiz.report.student')},
            {value: 'User Name', label: AJS.I18n.getText('quiz.report.user-name')},
            {value: 'Attempts', label: AJS.I18n.getText('quiz.report.attempts')},
            {value: 'Status', label: AJS.I18n.getText('quiz.report.status')},
            {value: 'Result', label: AJS.I18n.getText('quiz.report.result')},
            {value: 'Score', label: AJS.I18n.getText('quiz.report.score')},
            {value: 'Date Enrolled', label: AJS.I18n.getText('quiz.report.enrolled')},
            {value: 'Date Started', label: AJS.I18n.getText('quiz.report.started')},
            {value: 'Date Completed', label: AJS.I18n.getText('quiz.report.ended')},
            {value: 'Time Spent', label: AJS.I18n.getText('quiz.report.duration')},
            {value: 'Due Date', label: AJS.I18n.getText('quiz.report.due-date')},
            {value: 'Shared By', label: AJS.I18n.getText('quiz.report.author')},
            {value: 'Course', label: AJS.I18n.getText('com.stiltsoft.confluence.quiz.course.label')}];

        allColumns.forEach(function (column) {
            var checked = columns.indexOf(column.value) >= 0 ? ' checked' : '';
            var id = 'qc-' + column.value.replace(/\s/g, '').toLocaleLowerCase();
            columnsWrapper.append('<div><input id="' + id + '" type="checkbox" class="checkbox"' + checked +
                ' data-column="' + column.value + '"><label for="' + id + '">' + column.label + '</label></div>');
        });

        var showAnswersInput = $('#macro-param-show-answers');
        showAnswersInput.change(function () {
            if (showAnswersInput.is(':checked')) {
                exportInput.prop('checked', false);
            }
        });
        exportInput.change(function () {
            if (exportInput.is(':checked')) {
                showAnswersInput.prop('checked', false);
            }
        });

        return params;
    };

    AJS.MacroBrowser.setMacroJsOverride("quiz-answers-report", new MacroJsOverride());

})(AJS.$);





