(function($) {
    AJS.toInit(function() {
        $('.aui-progress-indicator').each(function () {
            var bar = $(this);
            AJS.progressBars.update(bar, parseFloat(bar.data('rate')) / 100);
        });

        $('.course-title-link').each(function () {
            var a = $(this);
            var text = a.text();

            while (a.height() > 36) {
                text = text.substring(0, text.length - 1).trim();
                a.text(text + '\u2026');
            }
        });

        $('.course-wrapper .aui-iconfont-delete').click(function () {
            var course = $(this).parents('.course-wrapper');

            var dialog = new AJS.Dialog({
                width: 500,
                height: 200,
                id: "delete-course-dialog",
                closeOnOutsideClick: false
            });

            dialog.addHeader(AJS.I18n.getText("quiz.report.dialog.delete.title"));
            dialog.addPanel('panel', "<div>" + AJS.I18n.getText("quiz.courses.delete") + "</div>", 'delete-course-dialog-panel');
            dialog.addButton(AJS.I18n.getText("quiz.report.dialog.delete.confirm"), function() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/course/answers/remove",
                    data: {
                        ids: course.data('id')
                    },
                    dataType: 'json',
                    success: function() {
                        course.remove();
                        dialog.remove();
                        if ($('.course-wrapper').length === 0) {
                            $('.courses-empty').show();
                        }
                    },
                    error: QuizErrorHandler.showError
                });
            }, "delete-course-dialog-save");
            dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                dialog.remove();
            }, '#');

            dialog.show();

            return false;
        });
    });
})(AJS.$);
