(function ($) {

    var CourseReport = {

        init: function() {
            var self = this;

            self.container = $('.course-participant-report');

            self.bindReportCollapser();
            self.fixBugWithDuplicateTHead();
        },

        bindReportCollapser: function() {
            var self = this;

            self.container.find('.collapser-container').unbind('click').click(function() {
                var btn = $(this);
                btn.toggleClass('expanded collapsed');
                btn.parents('td').find('.module-tree').toggle();

                return false;
            });
        },

        // https://jira.atlassian.com/browse/CONFSERVER-56489
        fixBugWithDuplicateTHead: function () {
            var self = this;
            self.container.bind('tablesorter-initialized', function () {
                TableSorterFixer.fix($(this));
                self.bindReportCollapser();
            });

            TableSorterFixer.fix(self.container);
        }
    };

    AJS.toInit(function() {
        CourseReport.init();
    });
})(AJS.$);

