(function($) {
    AJS.toInit(function() {
        var form = $('#qp-edit-permissions-form');

        form.find('.input-autocomplete').bind("selected.autocomplete-user-or-group", function(e, data) {
            addRestrictions($(this), data);
        });

        $('#qp-save').click(function () {
            $.ajax({
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/settings/permissions",
                data: {
                    groups: form.find('input.group:checked').map(function (i, input) { return input.id }).get(),
                    users: form.find('input.user:checked').map(function (i, input) { return input.id }).get()
                },
                dataType: 'json',
                success: function() {
                    location = form.find('#qp-cancel').attr('href');
                },
                error: QuizErrorHandler.showError
            });
        });

        function addRestrictions(input, data) {
            var container = form.find('#qp-' + data.content.type);
            input.val('');

            if (!hasRestriction(data.content, container)) {
                container.show();
                form.find('#empty-' + data.content.type).hide();

                var restriction;
                if (data.content.type === "user") {
                    restriction = QuizPermissions.user({name: data.content.key, fullName: data.content.title, key: data.content.userKey});
                } else {
                    restriction = QuizPermissions.group({group: data.content.key});
                }

                container.find("tbody").append(restriction);
                Confluence.Binder.userHover();
            }
        }

        function hasRestriction(data, container) {
            var restrictions = [];

            if (data.type === "user") {
                restrictions = container.find("tr[data-row-id='" + data.userKey + "']");
            }

            if (data.type === "group") {
                restrictions = container.find("tr[data-row-id='" + data.key + "']");
            }

            return restrictions.length > 0;
        }
    });
})(AJS.$);
