(function($) {
    AJS.toInit(function() {
        var form = $('#qca-edit-coauthors-form');

        form.find('.input-autocomplete').bind("selected.autocomplete-user-or-group", function(e, data) {
            addCoauthor($(this), data);
        });

        form.on('click', '.remove-coauthor span', function() {
            $(this).parents('tr').remove();
        });

        $('#qca-save').click(function () {
            $.ajax({
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/settings/coauthors",
                data: {
                    groups: form.find('tr.qca-group-container td').map(function (i, td) { return td.id }).get(),
                    users: form.find('tr.qca-user-container td').map(function (i, td) { return td.id }).get()
                },
                dataType: 'json',
                success: function() {
                    location = form.find('#qca-cancel').attr('href');
                },
                error: QuizErrorHandler.showError
            });
        });

        function addCoauthor(input, data) {
            var container = form.find('#qca-' + data.content.type);
            input.val('');

            if (!isAlreadyCoauthor(data.content, container)) {
                container.show();
                form.find('#empty-' + data.content.type).hide();

                var coauthor;
                if (data.content.type === "user") {
                    coauthor = QuizCoauthors.user({name: data.content.key, fullName: data.content.title, key: data.content.userKey});
                } else {
                    coauthor = QuizCoauthors.group({name: data.content.key});
                }

                container.find("tbody").append(coauthor);
                if (data.content.type === "user") Confluence.Binder.userHover();
            }
        }

        function isAlreadyCoauthor(data, container) {
            var coauthors = [];

            if (data.type === "user") {
                coauthors = container.find("#" + data.userKey);
            } else if (data.type === "group") {
                coauthors = container.find("#" + data.key);
            }

            return coauthors.length > 0;
        }
    });
})(AJS.$);
