import {iframeResizer} from "iframe-resizer";

//todo этой штуке явно нужен рефактор (счетчик нападений на этот файл: 1)
(function($) {
    AJS.toInit(function() {
        var frame = $('#quiz-review-question');
        var feedbackFrame = $('#feedback');
        var frameContent;
        var timeSpent = $('#time-spent');
        var prev = $('#prev');
        var next = $('#next');
        var numberedBtns = $('.quiz-review-question-btn');
        var reviewSelect = $('#review-select');
        var spinner = $('.quiz-spinner');
        var reviewComplete = $('#review-complete');
        var rereviewComplete = $('#rereview-complete');
        var qrc = $('#quiz-review-container');
        var total = parseInt(qrc.data('total'));
        var target = parseInt(qrc.data('target'));
        var status = parseInt(qrc.data('status'));
        var resubmit = qrc.data('resubmit');
        var btnContainer = $('.quiz-review-question-btn-container');
        var isReview = feedbackFrame.length === 0;
        var questionBaseUrl = Confluence.getContextPath();
        var baseUrl = Confluence.getContextPath();

        if (isReview) {
            baseUrl = baseUrl + '/quiz/test/review.action?qid=' + $.getUrlVar("qid") +
                '&uid=' + $.getUrlVar("uid");
            questionBaseUrl = questionBaseUrl + '/quiz/test/reviewQuestion.action?qid=' + $.getUrlVar("qid") +
                '&uid=' + $.getUrlVar("uid") + '&attempt=' + $.getUrlVar("attempt");
        } else {
            baseUrl = baseUrl + '/quiz/test/viewAnswers.action?qsd=';
            questionBaseUrl = questionBaseUrl + '/quiz/test/viewAnsweredQuestion.action?qsd=' + $.getUrlVar("qsd");
        }

        var active;
        var prevVal;
        var count = 1;
        var reviewIndex = btnContainer.index($('.null[data-question="' + $.getUrlVar("pid") + '"').eq(0));
        if (reviewIndex >= 0 && isReview) {
            count = reviewIndex + 1;
        } else {
            reviewIndex = btnContainer.index($('.null').eq(0));
            if (reviewIndex >= 0 && isReview) {
                count = reviewIndex + 1;
            } else {
                reviewIndex = btnContainer.index($('[data-question="' + $.getUrlVar("pid") + '"'));
                if (reviewIndex >= 0) {
                    count = reviewIndex + 1;
                }
            }
        }

        var getQuestion = function() {
            if (count == 1) {
                prev.prop('disabled', true);
            } else {
                prev.prop('disabled', false);
            }
            if (count == total) {
                next.prop('disabled', true);
            } else {
                next.prop('disabled', false);
            }

            $('#time-spent-text').hide();
            $('#not-answered').hide();
            $('#review-select-container').hide();
            numberedBtns.removeClass('active').prop('disabled', false);
            active = numberedBtns.eq(count - 1);
            active.addClass('active').prop('disabled', true);

            frame.css('height', 0);
            frame.attr('src', questionBaseUrl + '&questionId=' + active.data('question'));
            feedbackFrame.hide();
            feedbackFrame.attr('src', Confluence.getContextPath() + '/quiz/test/viewFeedback.action?qsd=' +
                $.getUrlVar("qsd") + '&questionId=' + active.data('question') + '&oldAttempt=true');
            spinner.show();
        };

        frame.on('load', function() {
            spinner.hide();
            frameContent = frame.contents().find('#main-content');

            new QuizFileViewerHelper(frame, frameContent);

            var data = {
                time: frameContent.attr('data-time'),
                answers: frameContent.attr('data-answers'),
                correct: frameContent.attr('data-correct'),
                sequence: frameContent.attr('data-sequence'),
                reviewerName: frameContent.attr('data-reviewerName'),
                reviewerFullName: frameContent.attr('data-reviewerFullName')

            };
            frameContent.find('.quiz-answers-container p').filter(function () { return $.trim(this.innerHTML) == "" }).remove();
            if ($(document).scrollTop() > 100) {
                $(document).scrollTop(100);
            }
            var variants = frameContent.find('.quiz-answer').click(function() {return false});

            AJS.progressBars.update("#answers-progress", count / total);
            $('#reviewed-count').html(count);
            timeSpent.text(data.time || '');
            if (!data.time) {
                $('#time-spent-text').hide();
                $('#not-answered').show();
            } else {
                $('#time-spent-text').show();
                $('#not-answered').hide();
            }

            if (data.sequence && data.sequence !== "empty") {
                $('#answers-na').hide();
                var variantsContainer = frameContent.find('.quiz-answers-container');
                var answers = data.answers.split(',');
                var sequence = data.sequence.split(',');
                var correct = data.correct.split(',');

                sequence.forEach(function(n, i) {
                    variantsContainer.append(variants.eq($.inArray(i.toString(), sequence)).parent());
                });
                variants = frameContent.find('.quiz-answer');

                variants.each(function(i) {
                    var input = $(this);
                    if ($.inArray(i.toString(), answers) > -1) {
                        if ($.inArray(i.toString(), correct) > -1) {
                            input.before('<span class="aui-icon aui-icon-small aui-iconfont-success"></span>');
                        } else {
                            input.before('<span class="aui-icon aui-icon-small"></span>');
                        }
                        input.prop('checked', true);
                    } else {
                        if ($.inArray(i.toString(), correct) > -1) {
                            input.before('<span class="aui-icon aui-icon-small aui-iconfont-success wrong"></span>');
                            input.prop('checked', false);
                        } else {
                            input.before('<span class="aui-icon aui-icon-small"></span>');
                        }
                    }
                });
            } else {
                variants.prop('checked', false);
                if (data.time && data.sequence === "empty") {
                    $('#answers-na').show();
                } else {
                    $('#answers-na').hide();
                }
            }

            var textarea = frameContent.find('.free-text-answer-review').val(data.answers).prop('readonly', true);
            if (textarea.length) {
                $('#answers-na').hide();
                if (data.time && (status === 2 || !resubmit)) {
                    $('#review-select-container').show();
                }
                if (active.hasClass('null')) {
                    $('#option-none').prop('selected', true);
                } else if (active.hasClass('true')) {
                    $('#option-true').prop('selected', true);
                } else {
                    $('#option-false').prop('selected', true);
                }

                prevVal = reviewSelect.val();

                $('#marked-correct, #marked-wrong').hide();
                if (data.reviewerName) {
                    var markedBy = active.hasClass('true') ? $('#marked-correct') : $('#marked-wrong');
                    markedBy.find('.confluence-userlink').replaceWith('<a href="' + AJS.params.contextPath + '/display/~' +
                        data.reviewerName + '" class="url fn confluence-userlink" data-username="' + data.reviewerName + '">' +
                        data.reviewerFullName + '</a>');
                    markedBy.show();
                    Confluence.Binder.userHover();
                }
            }

            var freeTextInput = frameContent.find('.free-text-answer').val(data.answers).prop('readonly', true);
            if (freeTextInput.length) {
                var correct = data.correct.split(',').map(function(c) {
                    return decodeURIComponent(c);
                });

                if (correct.indexOf(data.answers.trim()) !== -1) {
                    freeTextInput.before('<span class="quiz-review-btn-icon aui-icon aui-icon-small true"></span>');
                } else {
                    freeTextInput.before('<span class="quiz-review-btn-icon aui-icon aui-icon-small false"></span>');
                }

                frameContent.find('.possible-correct-answers').each(function() {
                    var el = $(this);
                    el.replaceWith("<span class='possible-correct-answers-span'>" + this.innerHTML + "</span>");
                });
            }
        });

        feedbackFrame.on('load', function () {
            var feedbackFrameContent = feedbackFrame.contents().find('#main-content');
            var showFeedback = feedbackFrameContent.text().trim() || feedbackFrameContent.find('img').length;
            if (showFeedback) {
                feedbackFrame.show();
            } else {
                feedbackFrame.hide();
            }
        });

        getQuestion();

        prev.click(function() {
            prev.blur();
            if (prev.prop('disabled'))
                return;

            var index = -1;
            for (var i = count - 2; i >= 0; i--) {
                if (numberedBtns.eq(i).hasClass('null')) {
                    index = i + 1;
                    break;
                }
            }
            if (index > -1) {
                count = index;
            } else {
                count--;
            }

            getQuestion();
        });

        next.click(function() {
            next.blur();
            if (next.prop('disabled'))
                return;

            var index = -1;
            for (var i = count; i < numberedBtns.length; i++) {
                if (numberedBtns.eq(i).hasClass('null')) {
                    index = i + 1;
                    break;
                }
            }
            if (index > -1) {
                count = index;
            } else {
                count++;
            }
            getQuestion();
        });

        numberedBtns.click(function() {
            count = $(this).blur().parent().index() + 1;
            getQuestion();
        });

        reviewSelect.change(function() {
            var value = reviewSelect.val();
            if (value == "none") {
                reviewSelect.val(prevVal);
                return false;
            }

            if (prevVal != value) {
                active = numberedBtns.eq(count - 1);
                $.ajax({
                    type: 'Post',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/answer/review",
                    data: {
                        qid: $.getUrlVar("qid"),
                        uid: $.getUrlVar("uid"),
                        attempt: $.getUrlVar("attempt"),
                        pageId: active.data('question'),
                        stateId: $.getUrlVar("id"),
                        correct: value
                    },
                    dataType: 'json',
                    success: function() {
                        if (prevVal != 'none' && numberedBtns.filter('.null').length == 0 && status === 2) {
                            reviewComplete.fadeIn();
                            setTimeout(function() {
                                reviewComplete.fadeOut();
                            }, 12000);
                        } else if (prevVal == 'none' && numberedBtns.filter('.null').length == 1 && status === 2) {
                            rereviewComplete.fadeIn();
                            setTimeout(function() {
                                rereviewComplete.fadeOut();
                            }, 12000);
                        }

                        prevVal = value;
                        active.add(active.parent()).removeClass('null').removeClass('true').removeClass('false').addClass(value);
                        $('#marked-correct, #marked-wrong').hide();
                        var markedBy = value == 'true' ? $('#marked-correct') : $('#marked-wrong');
                        markedBy.find('.confluence-userlink').replaceWith('<a href="' + AJS.params.contextPath + '/display/~' +
                                AJS.params.remoteUser + '" class="url fn confluence-userlink" data-username="' + AJS.params.remoteUser + '">' +
                                AJS.params.currentUserFullname + '</a>');
                        markedBy.show();
                        Confluence.Binder.userHover();

                        var correct = numberedBtns.filter('.true').length;
                        var percent = parseInt(correct * 1000 / total) / 10;

                        if (correct >= target) {
                            $('.passed').show();
                            $('.failed').hide();
                            active.attr('title', AJS.I18n.getText("quiz.review.correct"));
                        } else {
                            $('.passed').hide();
                            $('.failed').show();
                            active.attr('title', AJS.I18n.getText("quiz.review.wrong"));
                        }

                        $('.correct-percent').text(percent);
                        $('.correct').text(correct);
                    },
                    error: QuizErrorHandler.showError
                });
            }
        });

        reviewComplete.find('.icon-close').click(function() {
            reviewComplete.hide();
            return false;
        });

        $(document).bind('keyup', function(e) {
            if (e.which == 39) {
                next.click();
            } else if (e.which == 37) {
                prev.click();
            }
        });

        var settingsDialog = AJS.InlineDialog($('#quiz-settings button'), "quiz-settings", function(contents, trigger, showPopup) {
            contents.html(QuizReview.settingsDialog({
                target: target,
                timelimit: qrc.data('timelimit'),
                attempts: qrc.data('attempts'),
                showRes: qrc.data('showres'),
                showFeedback: qrc.data('showfeedback'),
                random: qrc.data('random'),
                skip: qrc.data('skip'),
                resubmit: qrc.data('resubmit')
            }));
            showPopup();
            contents.find('.aui-iconfont-close-dialog').click(function () {
                settingsDialog.hide()
            });
        }, {closeOnTriggerClick: true});

        var attemptsSelect = $('#attempts-select').change(function () {
            var option = attemptsSelect.find('option:selected');
            var pid = numberedBtns.filter('.active').data('question');
            if (isReview) {
                location.href = baseUrl + '&id=' + option.attr('value') + '&pid=' + pid + '&attempt=' + option.data('attempt');
            } else {
                location.href = baseUrl + option.attr('value') + '&pid=' + pid;
            }
        });

        var arrowUp = $('#quiz-attempts-container .arrow-up');
        var arrowDown = $('#quiz-attempts-container .arrow-down');

        var options = attemptsSelect.find('option');
        var attemptIndex = options.index(options.filter(':selected'));
        
        if (attemptIndex === 0) {
            arrowUp.addClass('disabled')
        }
        if (attemptIndex === options.length - 1) {
            arrowDown.addClass('disabled')
        }

        arrowUp.click(function () {
            if (!arrowUp.is('.disabled')) {
                options.eq(attemptIndex - 1).prop('selected', true);
                attemptsSelect.trigger('change');
            }
        });
        arrowDown.click(function () {
            if (!arrowDown.is('.disabled')) {
                options.eq(attemptIndex + 1).prop('selected', true);
                attemptsSelect.trigger('change');
            }
        });

        var userSelect = $('#users-select');
        userSelect.change(function () {
            var option = userSelect.find('option:selected');
            var pid = numberedBtns.filter('.active').data('question');
            location.search = '?qid=' + $.getUrlVar("qid") + '&uid=' + option.data("userid") + '&attempt=' +
                option.data('attempt') + '&id=' + option.attr('value') + '&pid=' + pid;
        }).auiSelect2({width: (248 - userSelect.parent().find('label').width()) + 'px'});

        iframeResizer({log: false, checkOrigin: false}, '#quiz-review-question');
    });
})(AJS.$);


