import moment from 'moment';
import {IFRAME_DELETED_ENROLL_MESSAGE} from '../../utils/constants/iframe-messages';
import {ENROLL_NOT_FOUND, ENROLL_STARTED, ENROLL_NOT_STARTED} from "../../utils/constants/enroll-states";
import {showQuizEnrollNotFoundMessage} from "../../utils/messages";
import {iframeResizer} from "iframe-resizer";

(function($) {

    const ONE_SECOND_MS = 1000;

    AJS.toInit(function() {
        var isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
        if (isMobile) {
            $('#main').css('padding', '10px');
            $('#quiz-nav-progress-container-td').css('padding-left', '10px');
            $('#quiz-nav-sidebar').width('112px');
            $('#header .aui-header-secondary').hide();
            $('#header .aui-header-primary .aui-buttons').hide();
        }

        var answerData;
        var startContainer = $('#quiz-test-container');
        var frame = $('#quiz-test-progress-frame');
        var frameContent;
        var feedbackFrame = $('#feedback');
        var feedbackFrameContent;
        var feedbackCallback = function () {};
        var counter = $('#time-left');
        var btn = $('#answer');
        var skipBtn = $('#skip');
        var continueBtn = $('.continue');
        var spinner = $('.quiz-spinner');
        var answerSpinner = $('#answer-spinner');
        var numberedBtns = $('.quiz-nav-question-btn');
        var count = 1;
        var isResubmit = startContainer.data('resubmit') == true;

        bindIframeEvents();

        var finish = function() {
            location.reload();
        };

        var getQuestion = function(questionId) {
            continueBtn.hide();
            $('.show-answer-message').hide();
            feedbackFrame.hide();
            $(document).scrollTop(0);

            spinner.show();
            frame.css('height', 0);
            frame.attr('src', Confluence.getContextPath() + '/quiz/test/viewQuestion.action?qsd=' + $.getUrlVar("qsd") + '&questionId=' + (questionId || ''));
        };

        var getFrameContent = function () {
            frameContent = frame.contents().find('#main-content');
        };

        var updateProgressBar = function() {
            AJS.progressBars.update("#answers-progress", frameContent.data('answered') / frameContent.data('total'));
            $('#answered-count').html(frameContent.data('answered'));
        };

        frame.on('load', function() {
            getFrameContent();

            new QuizFileViewerHelper(frame, frameContent);

            $('#buttons-container').show();
            btn.show();
            var prevActive = numberedBtns.filter('.active');
            prevActive.removeClass('active');
            if (isResubmit || prevActive.hasClass('not-answered')) prevActive.prop('disabled', false);
            var active = numberedBtns.filter('[data-question="' + frameContent.data('id') + '"]');
            active.addClass('active').prop('disabled', true);
            count = numberedBtns.index(active) + 1;
            spinner.hide();
            var variants = frameContent.find('.quiz-answer');
            var freeTextInput = frameContent.find('.free-text-answer-review, .free-text-answer');
            variants.change(function() {
                btn.prop('disabled', false);
            });
            freeTextInput.bind('input keyup paste', function() {
                freeTextInput.removeClass('answered');
                btn.prop('disabled', false);
            });
            if (variants.attr('type') == "checkbox") {
                btn.prop('disabled', false);
            }
            if (counter.length) {
                var timeLimitMs = frameContent.data('finish') - frameContent.data('now');
                var duration = moment.duration(timeLimitMs);

                var intervalDescriptor;
                intervalDescriptor = setInterval(function(){
                    duration = moment.duration(duration - ONE_SECOND_MS);
                    counter.html(moment.utc(duration.asMilliseconds()).format('HH:mm:ss'));
                    if (duration.asSeconds() < 1) {
                        clearInterval(intervalDescriptor);

                        $.ajax({
                            type: 'POST',
                            cache: false,
                            async: false,
                            url: Confluence.getContextPath() + "/rest/quiz/1.0/service/finish",
                            data: {
                                param: $.getUrlVar("qsd"),
                                giveUp: true
                            },
                            dataType: 'json',
                            success: function(data) {
                                if (data.value === ENROLL_NOT_FOUND) {
                                    showQuizEnrollNotFoundMessage();
                                } else {
                                    finish();
                                }
                            },
                            error: QuizErrorHandler.showError
                        });
                    }
                }, ONE_SECOND_MS);
            }
            if (frameContent.data('skip') || isResubmit) {
                skipBtn.show();
                skipBtn.prop('disabled', false);
            } else {
                skipBtn.hide();
            }

            updateProgressBar();
            frameContent.children('p').filter(function () { return $.trim(this.innerHTML.replace('&nbsp;', '')) == "" }).remove();

            if (numberedBtns.length && !active.hasClass('not-answered') && isResubmit) {
                btn.text(AJS.I18n.getText('quiz.test.reanswer')).prop('disabled', true);
                if (active.hasClass('correct')) {
                    btn.hide();
                    variants.prop('disabled', true);
                }
                skipBtn.text(AJS.I18n.getText('quiz.test.skip.next'));
            } else {
                btn.text(AJS.I18n.getText('quiz.test.answer'));
                skipBtn.text(AJS.I18n.getText('quiz.test.skip'));
            }

            if (frameContent.attr('data-sequence') || frameContent.attr('data-answers')) {
                if (freeTextInput.length) {
                    freeTextInput.val(frameContent.data('answers')).addClass('answered');
                } else {
                    var variantsContainer = frameContent.find('.quiz-answers-container');
                    var sequence = frameContent.attr('data-sequence').split(',');
                    sequence.forEach(function(n, i) {
                        variantsContainer.append(variants.eq($.inArray(i.toString(), sequence)).parent());
                    });
                    if (frameContent.attr('data-answers')) {
                        variants = variantsContainer.find('.quiz-answer');
                        frameContent.attr('data-answers').split(',').forEach(function(n) {
                            variants.eq(n).prop('checked', true);
                        });
                    }
                }
            }

            if (isMobile) frameContent.find('iframe').css('height', '');
        });

        feedbackFrame.on('load', function () {
            feedbackFrameContent = feedbackFrame.contents().find('#main-content');
            var showFeedback = feedbackFrameContent.text().trim() || feedbackFrameContent.find('img').length;
            if (showFeedback) {
                feedbackFrame.show();
            } else {
                feedbackFrame.hide();
            }

            feedbackCallback(showFeedback);
        });

        var skip = function(nextId) {
            btn.prop('disabled', true);
            skipBtn.prop('disabled', true);

            $.ajax({
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/skip",
                data: {
                    param: $.getUrlVar("qsd"),
                    pid: frameContent.data("id"),
                    attempt: frameContent.data("attempt"),
                    nextId: nextId
                },
                dataType: 'json',
                success: function() {
                    getQuestion(nextId);
                },
                error: QuizErrorHandler.showError
            });
        };

        var checkForAnswerLoss = function(callback) {
            if ($.trim(frameContent.find('.free-text-answer-review:not(.answered)').val())) {
                var dialog = new AJS.Dialog({
                    width: isMobile ? 310 : 550,
                    height: isMobile ? 220 : 200,
                    id: "skip-dialog",
                    closeOnOutsideClick: false
                });

                dialog.addHeader(AJS.I18n.getText("quiz.test.skip"));
                dialog.addPanel('panel', "<div>" + AJS.I18n.getText("quiz.test.skip.dialog.body") + "</div>", 'skip-dialog-panel');
                dialog.addButton(AJS.I18n.getText("quiz.test.skip"), function() {
                    callback();
                    dialog.remove();
                }, "skip-dialog-ok");
                dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                    dialog.remove();
                }, '#');

                dialog.show();
            } else {
                return true;
            }
            return false
        };

        getFrameContent();
        
        var maxWidth = frame.width();
        if (startContainer.data('progress') == '0') {
            $('#start-quiz').click(function() {
                $('#quiz-test-start').remove();
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/test/start",
                    data: {
                        param: $.getUrlVar("qsd")
                    },
                    dataType: 'json',
                    success: function(data) {
                        if (data.value === ENROLL_NOT_FOUND) {
                            showQuizEnrollNotFoundMessage();
                        } else if (data.value === ENROLL_STARTED) {
                            $('#quiz-test-progress-container').show();
                            maxWidth = frame.width();
                            getQuestion();
                        } else if (data.value === ENROLL_NOT_STARTED) {
                            location.reload();
                        }
                    },
                    error: function (xhr) {
                        if (xhr.status === 403) {
                            location.reload();
                        } else {
                            QuizErrorHandler.showError(xhr);
                        }
                    }
                });
            });

            if (startContainer.data('review') > 0) {
                $('.quiz-start-element-free-text').html(startContainer.data('review'));
            } else {
                $('.quiz-start-element-free-text').parent().remove()
            }
            if (startContainer.data('timelimit')) {
                $('.quiz-start-element-time-limit').html(startContainer.data('timelimit'));
            } else {
                $('.quiz-start-element-time-limit').parent().remove()
            }
            if (startContainer.data('description')) {
                $('.quiz-start-element-description').html(startContainer.data('description'));
            } else {
                $('.quiz-start-element-description').parent().remove()
            }
            if (startContainer.data('duedate')) {
                $('.quiz-start-element-due-date').html(startContainer.data('duedate'));
            } else {
                $('.quiz-start-element-due-date').parent().remove()
            }
            $('.quiz-start-element-target').html(startContainer.data('target'));
            $('.quiz-start-element-total').html(startContainer.data('total'));
            $('#quiz-test-start').css('display', 'block');
        } else {
            getQuestion();
            if (isResubmit && numberedBtns.filter('.not-answered').length == 0) {
                $('#give-up-info').show();
            }
        }

        function answer(async, callback) {
            answerSpinner.css('visibility', 'visible');
            btn.prop('disabled', true);
            skipBtn.prop('disabled', true);
            numberedBtns.prop('disabled', true);
            var answers = [];
            var answerOptions = frameContent.find('.quiz-answer').each(function(i) {
                if ($(this).is(':checked')) {
                    answers.push(i);
                }
            }).prop('disabled', true);
            var freeTextInput = frameContent.find('.free-text-answer-review, .free-text-answer');
            if (freeTextInput.length) {
                answers.push(freeTextInput.val().trim());
                freeTextInput.prop('disabled', true);
            }

            $.ajax({
                type: 'POST',
                cache: false,
                async: async,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/answer",
                data: {
                    param: $.getUrlVar("qsd"),
                    pid: frameContent.data("id"),
                    attempt: frameContent.data("attempt"),
                    started: frameContent.data("started") || -1,
                    answers: answers,
                    isAutoCheckedFreeText: freeTextInput.length > 0 && freeTextInput.hasClass("free-text-answer")
                },
                dataType: 'json',
                success: callback || function(data, msg, xhr) {
                    if (xhr.status === 304) {
                        AJS.flag({
                            type: 'error',
                            body: AJS.I18n.getText("quiz.test.question.session.error")
                        });
                        return;
                    }
                    if (data.status === ENROLL_NOT_FOUND) {
                        showQuizEnrollNotFoundMessage();
                    }
                    
                    var activeNavBtn = numberedBtns.filter('.active');
                    activeNavBtn = activeNavBtn.add(activeNavBtn.parent());
                    activeNavBtn.removeClass('not-answered correct wrong');
                    if (data.isReview) {
                        activeNavBtn.addClass('review').attr('title', AJS.I18n.getText('quiz.test.nav.review'));
                    } else {
                        activeNavBtn.addClass('answered').attr('title', AJS.I18n.getText('quiz.test.nav.answered'));
                    }

                    answerData = data;
                    freeTextInput.addClass('answered');
                    feedbackCallback = function (showFeedback) {
                        frameContent.data('answered', data.answered);
                        updateProgressBar();
                        if (isResubmit) {
                            numberedBtns.not('.active').prop('disabled', false);
                        } else if (frameContent.data('skip')) {
                            numberedBtns.filter('.not-answered').prop('disabled', false);
                        }
                        answerSpinner.css('visibility', '');
                        if (data.showRes || showFeedback) {
                            if (isResubmit) {
                                $('.show-answer-message').hide();
                                btn.text(AJS.I18n.getText('quiz.test.reanswer'));
                                skipBtn.text(AJS.I18n.getText('quiz.test.skip.next')).prop('disabled', false);
                                answerOptions.prop('disabled', false);
                                freeTextInput.prop('disabled', false);
                                if (numberedBtns.filter('.not-answered').length == 0) {
                                    $('#give-up-info').show();
                                }
                            } else {
                                $('#buttons-container').hide();
                                continueBtn.show();
                            }

                            if (data.showRes) {
                                activeNavBtn.removeClass('answered');
                                if (data.isReview) {
                                    $('#review').show();
                                } else if (data.isCorrect) {
                                    $('#correct').show();
                                    activeNavBtn.removeClass('review').addClass('correct').attr('title', AJS.I18n.getText('quiz.test.nav.correct'));
                                    if (isResubmit) {
                                        btn.hide();
                                        answerOptions.prop('disabled', true);
                                    }
                                } else {
                                    if (isResubmit) {
                                        $('#wrong-resubmit').show();
                                    } else {
                                        $('#wrong').show();
                                    }
                                    activeNavBtn.removeClass('review').addClass('wrong').attr('title', AJS.I18n.getText('quiz.test.nav.wrong'));
                                }
                            }
                        } else if (data.correct == -1) {
                            if (!isResubmit || numberedBtns.filter('.not-answered').length) {
                                getQuestion();
                            } else {
                                btn.text(AJS.I18n.getText('quiz.test.reanswer'));
                                skipBtn.text(AJS.I18n.getText('quiz.test.skip.next')).prop('disabled', false);
                                answerOptions.prop('disabled', false);
                                freeTextInput.prop('disabled', false);
                                $('#give-up-info').show();
                            }
                        } else {
                            finish();
                        }
                    };

                    if (data.showFeedback) {
                        feedbackFrame.attr('src', Confluence.getContextPath() + '/quiz/test/viewFeedback.action?qsd=' + $.getUrlVar("qsd") + '&questionId=' + frameContent.data("id"));
                    } else {
                        feedbackCallback(false);
                    }
                },
                error: QuizErrorHandler.showError
            });
        }

        btn.click(function() {
             answer(true);
         });

        skipBtn.click(function() {   
            if (skipBtn.prop('disabled')) return;
            
            var getNextQuestion = function() {
                if (numberedBtns.length == 0) skip();

                var index = -1;
                for (var i = count; i < numberedBtns.length; i++) {
                    if (numberedBtns.eq(i).hasClass('not-answered')) {
                        index = i + 1;
                        break;
                    }
                }
                if (index == -1) {
                    index = $('.quiz-nav-question-btn-container').index($('.not-answered').eq(0)) + 1;
                }

                if (index > 0) {
                    count = index;
                } else if (isResubmit) {
                    count++;
                    count = count % numberedBtns.length;
                } else {
                    return;
                }

                skip(numberedBtns.eq(count - 1).data('question'));
            };
            //todo это гениально!!! но стоит как-то понятнее обойтись с ветвистостью условий
            if (checkForAnswerLoss(getNextQuestion)) {
                getNextQuestion();
            }
        });

        numberedBtns.click(function() {
            var navBtn = $(this);
            var getNextQuestion = function() {
                count = navBtn.blur().parent().index() + 1;
                skip(navBtn.data('question'));
            };
            if (checkForAnswerLoss(getNextQuestion)) {
                getNextQuestion();
            }
        });

        continueBtn.click(function() {
            if (answerData.correct == -1) {
                getQuestion();
            } else {
                finish();
            }
        });

        $('#give-up').click(function() {
            var hasAnswer = numberedBtns.filter('.active').hasClass('not-answered') &&
                ($.trim(frameContent.find('.free-text-answer-review:not(.answered)').val()) ||
                frameContent.find('input.quiz-answer:checked').length);

            var dialogHeight = isMobile ? 240 : 200;
            if (hasAnswer) {
                dialogHeight += 170;
            }

            var dialog = new AJS.Dialog({
                width: isMobile ? 310 : 560,
                height: dialogHeight,
                id: "give-up-dialog",
                closeOnOutsideClick: false
            });

            dialog.addHeader(AJS.I18n.getText("quiz.test.give-up"));
            dialog.addPanel('panel', QuizAction.submitDialog({hasAnswer: hasAnswer}), 'give-up-dialog-panel');
            dialog.addButton(AJS.I18n.getText("quiz.test.give-up"), function() {
                if ($('#quiz-submit-answered').is(':checked')) {
                    answer(false, function () {
                        $(window).unbind('beforeunload');
                    });
                }

                $.ajax({
                    type: 'POST',
                    cache: false,
                    async: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/service/finish",
                    data: {
                        param: $.getUrlVar("qsd"),
                        giveUp: true
                    },
                    dataType: 'json',
                    success: function(data) {
                        if (data.value === ENROLL_NOT_FOUND) {
                            showQuizEnrollNotFoundMessage();
                        } else {
                            finish();
                        }
                    },
                    error: QuizErrorHandler.showError
                });
                dialog.remove();
            }, "give-up-dialog-ok");
            dialog.addLink(AJS.I18n.getText("quiz.create-wizard.dialog.cancel"), function (dialog) {
                dialog.remove();
            }, '#');

            dialog.show();
        });

        $(window).bind('beforeunload', function() {
            if ($.trim(frameContent.find('.free-text-answer-review:not(.answered)').val())) {
                return AJS.I18n.getText("quiz.test.skip.dialog.body");
            }
        });

        $(document).bind('keyup', function(e) {
            if (e.which == 39) {
                skipBtn.click();
            }
        });
    });

    function bindIframeEvents() {
        window.addEventListener("message", (e) => {
            if (e.data === IFRAME_DELETED_ENROLL_MESSAGE) {
                showQuizEnrollNotFoundMessage();
            }
        });

        iframeResizer({log: false, checkOrigin: false}, '#quiz-test-progress-frame');
        iframeResizer({log: false, checkOrigin: false}, '#feedback');
    }
})(AJS.$);

