import {ENROLL_NOT_FOUND, QUIZ_ENROLL_NOT_RESTARTED} from "../../utils/constants/enroll-states";
import {showQuizEnrollNotFoundMessage} from "../../utils/messages";

(function($) {
    AJS.toInit(function() {
        var isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
        if (isMobile) {
            $('#main').css('padding', '10px');
            $('#quiz-nav-progress-container-td').css('padding-left', '10px');
            $('#quiz-nav-sidebar').width('112px');
            $('#header .aui-header-secondary').hide();
            $('#header .aui-header-primary .aui-buttons').hide();
        }

        $('#restart-quiz').one('click', function() {
            $.ajax({
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/service/test/restart",
                data: {
                    param: $.getUrlVar("qsd")
                },
                dataType: 'json',
                success: function(data) {
                    if (data.value === ENROLL_NOT_FOUND) {
                        showQuizEnrollNotFoundMessage();
                    } else if (data.value === QUIZ_ENROLL_NOT_RESTARTED) {
                        showQuizEnrollNotFoundMessage();
                    } else {
                        location.search = '?qsd=' + data.value;
                    }
                },
                error: QuizErrorHandler.showError
            });
        });

        var container = $('#quiz-test-container');
        $('.quiz-result-element-correct').html(container.data('correct'));
        $('.quiz-result-element-score').html(container.data('percent') + '%');
        $('.quiz-result-element-target').html(container.data('target'));
        $('.quiz-result-element-total').html(container.data('total'));
        $('.quiz-result-element-participant').html(container.data('participant'));
    });

})(AJS.$);


