(function($) {

    //todo на самом деле этот файлик имеет две ответственности: отвечает за расширение квиза внутри курса
    //и за показ preview картинок
    //(в частности из-за этого внутри торчит селектор #course-module-frame)
    var QuizFileViewerHelper = function (frame, content) {
        this.frame = frame;
        this.framDoc = $(frame.contents());
        this.content = content;
        this.footer = $('#footer-logo');
        this.bindShow();
        this.bindDialog();
    };

    QuizFileViewerHelper.prototype.bindShow = function () {
        var self = this;

        self.content.on('click', 'img.confluence-embedded-image, .confluence-embedded-file', function () {
            self.timer = null;
            self.timerCounter = 0;
            self.onShow();
        });
    };

    QuizFileViewerHelper.prototype.bindDialog = function () {
        var self = this;

        if (self.frame[0].contentWindow.AJS) {
            self.frame[0].contentWindow.AJS.bind('show.dialog', function () {
                self.show();
            });

            self.frame[0].contentWindow.AJS.bind('hide.dialog remove.dialog', function () {
                self.close();
            });
        }
    };

    QuizFileViewerHelper.prototype.onShow = function () {
        var self = this;
        clearTimeout(self.timer);
        if (self.timerCounter++ < 500) {
            if (self.framDoc.find('.cp-container, #cp-container').length) {
                self.show();
                self.bindClose();
            } else {
                self.timer = setTimeout(function() {self.onShow()}, 50);
            }
        }
    };

    QuizFileViewerHelper.prototype.show = function () {
        var self = this;
        self.frame.addClass('preview');
        self.footer.addClass('preview');
        $(window.parent.document).find('#course-module-frame, #footer-logo').addClass('preview');
    };

    QuizFileViewerHelper.prototype.bindClose = function () {
        var self = this;
        self.framDoc.bind('keyup.quiz, click.quiz', function () {
            self.timer = null;
            self.timerCounter = 0;
            self.onClose();
        });
    };

    QuizFileViewerHelper.prototype.onClose = function () {
        var self = this;
        clearTimeout(self.timer);
        if (self.timerCounter++ < 100) {
            if (self.framDoc.find('.cp-container, #cp-container').length === 0) {
                self.frame.removeClass('preview');
                self.footer.removeClass('preview');
                self.framDoc.unbind('keyup.quiz, click.quiz');
                $(window.parent.document).find('#course-module-frame, #footer-logo').removeClass('preview');
            } else {
                self.timer = setTimeout(function() {self.onClose()}, 50);
            }
        }
    };

    QuizFileViewerHelper.prototype.close = function () {
        var self = this;
        self.frame.removeClass('preview');
        self.footer.removeClass('preview');
        self.framDoc.unbind('keyup.quiz, click.quiz');
        $(window.parent.document).find('#course-module-frame, #footer-logo').removeClass('preview');
    };

    window.QuizFileViewerHelper = QuizFileViewerHelper;

})(AJS.$);
