(function($) {
    var Categories = {

        init: function () {
            var self = this;

            self.container = $('#course-category-management');
            self.categoriesWrapper = self.container.find('#course-categories tbody');
            
            self.bindAdd();
            self.bindEdit();
            self.bindDelete();
            self.bindSort();
        },

        bindAdd: function () {
            var self = this;
            var btn = self.container.find('#create-course-category');
            var input = self.container.find('#course-category-input');

            input.bind('input', function (e) {
                btn.prop('disabled', !input.val().trim());
                if (e.which === 13) {
                    btn.click();
                }
            });

            btn.click(function () {
                btn.prop('disabled', true);
                var name = input.val().trim();

                if (!self.hasCategory(name)) {
                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/categories/add-category",
                        data: {
                            name: name
                        },
                        dataType: 'json',
                        success: function(id) {
                            input.val('');
                            self.categoriesWrapper.append(CourseCategories.category({category: name, id: id}));
                            self.container.removeClass('empty');
                        },
                        error: function (xhr) {
                            btn.prop('disabled', false);
                            QuizErrorHandler.showError(xhr);
                        }
                    });
                } else {
                    AJS.flag({
                        type: 'error',
                        body: AJS.I18n.getText("quiz.learning.administration.categories.add.exists")
                    });
                }
            })
        },

        bindEdit: function () {
            var self = this;

            self.categoriesWrapper.on('click', '.edit-category', function () {
                var row = $(this).parents('tr');
                row.addClass('edit');
                row.find('input').val(row.find('.category-text').text()).focus().trigger('input');
            });

            self.categoriesWrapper.on('click', '.cancel-category', function () {
                var row = $(this).parents('tr');
                row.removeClass('edit');
            });


            self.categoriesWrapper.on('input', 'input', function (e) {
                var input = $(this);
                var updateBtn = input.parents('tr').find('.save-category');
                if (input.val().trim()) {
                    updateBtn.removeClass('disabled');
                } else {
                    updateBtn.addClass('disabled');
                }

                input.width(input.textWidth() + parseInt(input.css('padding-left')) + parseInt(input.css('padding-right')) + 2);
            }).on('keyup', 'input', function (e) {
                if (e.which === 13) {
                    $(this).parents('tr').find('.save-category').click();
                }
            });

            self.categoriesWrapper.on('click', '.save-category', function () {
                var updateBtn = $(this);
                if (!updateBtn.is('.disabled')) {
                    var row = updateBtn.parents('tr');
                    var name = row.find('input').val().trim();
                    var categoryView = row.find('.category-text');

                    if (!self.hasCategory(name, categoryView)) {
                        $.ajax({
                            type: 'POST',
                            cache: false,
                            url: Confluence.getContextPath() + "/rest/quiz/1.0/categories/update-category",
                            data: {
                                id: row.attr('id'),
                                name: name
                            },
                            dataType: 'json',
                            success: function() {
                                categoryView.text(name);
                                row.find('.cancel-category').click();
                            },
                            error: QuizErrorHandler.showError
                        });
                    } else {
                        AJS.flag({
                            type: 'error',
                            body: AJS.I18n.getText("quiz.learning.administration.categories.add.exists")
                        });
                    }
                }
            });
        },

        bindDelete: function() {
            var self = this;

            self.categoriesWrapper.on('click', '.delete-category', function () {
                var row = $(this).parents('tr');

                $.ajax({
                    type: 'GET',
                    cache: false,
                    url: Confluence.getContextPath() + "/rest/quiz/1.0/categories/usage-category",
                    data: {
                        id: row.attr('id')
                    },
                    dataType: 'json',
                    success: function(courses) {
                        if (courses.length) {
                            $('#used-courses').html(CourseCategories.courses({courses: courses}));
                            AJS.dialog2("#delete-category-dialog").show();
                            $('#delete-category-dialog-confirm').click(function () {
                                self.delete(row);
                                AJS.dialog2("#delete-category-dialog").hide();
                            });
                            $('#delete-category-dialog-cancel').click(function () {
                                AJS.dialog2("#delete-category-dialog").hide();
                            });
                        } else {
                            self.delete(row);
                        }
                    },
                    error: QuizErrorHandler.showError
                });
            });
        },

        bindSort: function () {
            var self = this;

            self.categoriesWrapper.sortable({
                containment: 'parent',
                items: "tr",
                handle: '.category-draggable',
                axis: 'y',
                helper: "clone",
                tolerance: 'pointer',
                start: function(e, ui, b) {
                    ui.item.show();
                    ui.placeholder.append('<td></td><td></td><td></td>');
                    ui.placeholder.find('td').eq(1).add(ui.helper.find('td').eq(1)).width(ui.item.find('td').eq(1).width());
                    ui.item.hide();
                },
                update: function (e, ui) {
                    ui.item.find('.category-text').width('');
                    var ids = [];
                    self.categoriesWrapper.find('tr').each(function () {
                        ids.push($(this).data('id'));
                    });

                    $.ajax({
                        type: 'POST',
                        cache: false,
                        url: Confluence.getContextPath() + "/rest/quiz/1.0/categories/reorder",
                        data: {
                            ids: self.categoriesWrapper.find('tr').map(function (i, tr) { return tr.id }).get()
                        },
                        dataType: 'json',
                        error: QuizErrorHandler.showError
                    });
                }
            });
        },

        delete: function(row) {
            $.ajax({
                type: 'POST',
                cache: false,
                url: Confluence.getContextPath() + "/rest/quiz/1.0/categories/delete-category",
                data: {
                    id: row.attr('id')
                },
                dataType: 'json',
                success: function() {
                    row.remove();
                },
                error: QuizErrorHandler.showError
            });
        },

        hasCategory: function (name, exclusion) {
            var self = this;
            var categories = self.categoriesWrapper.find('.category-text').not(exclusion).filter(function () {
                return $(this).text().trim().toLocaleLowerCase() === name.toLocaleLowerCase();
            });
            return categories.length;
        }
    };

    AJS.toInit(function() {
        Categories.init();
    });

    $.fn.textWidth = function() {
        if (!$.fn.textWidth.fakeEl) $.fn.textWidth.fakeEl = $('<span>').hide().appendTo(document.body);
        $.fn.textWidth.fakeEl.text(this.val() || this.text()).css('font', this.css('font'));
        return $.fn.textWidth.fakeEl.width();
    };
})(AJS.$);

