import AJS from 'ajs';
import {DC_FEEDBACK_LINK, SERVER_FEEDBACK_LINK} from "../../utils/constants/feedback-links";

AJS.toInit(function() {
    let $ = AJS.$;

    var btn;
    $('#learning-page-content button[data-content-blueprint-id]').click(function() {
        btn = $(this);
        dialog.show();
    });

    var dialog = AJS.dialog2("#quiz-bp-space-dialog");

    var spaceInput = dialog.$el.find('#space-key');
    spaceInput.bind('selected.autocomplete-content', function(e, data) {
        spaceInput.data('key', data.content.key);
    });

    dialog.$el.find('#quiz-bp-cancel').click(function() {
        dialog.hide();
    });

    dialog.$el.find('#quiz-bp-next').click(function() {
        var data = btn.data();
        data.spaceKey = spaceInput.data('key');
        dialog.hide();
        Confluence.Blueprint.loadDialogAndOpenTemplate(data);
    });

    dialog.$el.css('margin-top', ($(window).height() - 449) / 2 - 100);

    setFeedbackLinkHrefDependsOnLicenseType($('#learning-feedback'));
});

function setFeedbackLinkHrefDependsOnLicenseType(feedbackLink) {
    let isDcLicense = feedbackLink.data('is-dc-license');
    if (isDcLicense === true) {
        feedbackLink.attr('href', DC_FEEDBACK_LINK);
    } else {
        feedbackLink.attr('href', SERVER_FEEDBACK_LINK);
    }
}
