/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.workbox;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkboxManager {
    private static final Logger log = LoggerFactory.getLogger(WorkboxManager.class);
    private UserAccessor userAccessor;
    private SettingsManager settingsManager;
    private LocalNotificationService localNotificationService;
    private WikiStyleRenderer wikiStyleRenderer;

    public WorkboxManager(UserAccessor userAccessor, SettingsManager settingsManager, LocalNotificationService localNotificationService, WikiStyleRenderer wikiStyleRenderer) {
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
        this.localNotificationService = localNotificationService;
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void addQuizNotification(ConfluenceUser user, ConfluenceUser author, AbstractPage page, int userId, int authorId, int recordId, String desc) {
        this.addNotification(user, author, page, userId, authorId, recordId, desc, "quiz", "/quiz/test/view.action");
    }

    public void addCourseNotification(ConfluenceUser user, ConfluenceUser author, AbstractPage page, int userId, int authorId, int recordId, String desc) {
        this.addNotification(user, author, page, userId, authorId, recordId, desc, "course", "/quiz/course/view.action");
    }

    private void addNotification(ConfluenceUser user, ConfluenceUser author, AbstractPage page, int userId, int authorId, int recordId, String desc, String type, String url) {
        try {
            ObjectNode metadata = new ObjectMapper().createObjectNode();
            metadata.put("user", author.getFullName());
            metadata.put("page", page.getTitle());
            Notification notification = new NotificationBuilder().application(type.equals("quiz") ? "com.stiltsoft.confluence.quiz.workbox" : "com.stiltsoft.confluence.quiz.course.workbox").entity(type).action("view").read(user.getKey().equals((Object)author.getKey())).itemTitle(page.getTitle()).itemUrl(this.settingsManager.getGlobalSettings().getBaseUrl() + url + "?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, authorId, user.getKey().getStringValue(), recordId)))).iconUrl(this.settingsManager.getGlobalSettings().getBaseUrl() + this.userAccessor.getUserProfilePicture((User)author).getDownloadPath()).description(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext((ContentEntityObject)page), desc)).metadata(metadata).groupingId(String.valueOf(recordId)).createNotification();
            this.localNotificationService.createOrUpdate(user.getName(), notification).get();
        }
        catch (Exception e) {
            log.error("Unable to put the new 'quiz notifications' to workbox", (Throwable)e);
        }
    }
}

