/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils.search;

import java.util.List;
import java.util.function.Consumer;

public class SearchQueryBuilder {
    private static final String TITLE = "title:";
    private static final String LABEL = "labelText:";
    private static final String MACRO = "macroName:";
    private static final String TYPE = "type:";
    private static final String SPACE = "space:";
    private static final String GROUP_START = "(";
    private static final String GROUP_END = ")";
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String NOT = " NOT ";
    private static final String WILDCARD = "*";
    private final StringBuilder sb = new StringBuilder();

    public SearchQueryBuilder setTitle(String title) {
        String escaped = this.escapeTitle(title);
        this.sb.append(GROUP_START).append(TITLE).append(escaped).append(OR).append(TITLE).append(escaped).append(WILDCARD).append(GROUP_END);
        return this;
    }

    public SearchQueryBuilder setLabel(String label) {
        this.appendParam(LABEL, label);
        return this;
    }

    public SearchQueryBuilder setSpace(String key) {
        this.appendParam(SPACE, key);
        return this;
    }

    public SearchQueryBuilder setMacro(String macro) {
        this.appendParam(MACRO, macro);
        return this;
    }

    public SearchQueryBuilder or() {
        if (this.sb.length() > 0) {
            this.sb.append(OR);
        }
        return this;
    }

    public SearchQueryBuilder and() {
        if (this.sb.length() > 0) {
            this.sb.append(AND);
        }
        return this;
    }

    public SearchQueryBuilder not() {
        this.sb.append(NOT);
        return this;
    }

    public SearchQueryBuilder startGroup() {
        this.sb.append(GROUP_START);
        return this;
    }

    public SearchQueryBuilder endGroup() {
        this.sb.append(GROUP_END);
        return this;
    }

    public SearchQueryBuilder orLabelsGroup(List<String> labels) {
        if (labels.size() > 0) {
            this.appendGroup(labels, LABEL, label -> {
                this.sb.append(OR);
                this.appendParam(LABEL, (String)label);
            });
        }
        return this;
    }

    public SearchQueryBuilder orMacrosGroup(List<String> macros) {
        if (macros.size() > 0) {
            this.appendGroup(macros, MACRO, macro -> {
                this.sb.append(OR);
                this.appendParam(MACRO, (String)macro);
            });
        }
        return this;
    }

    public String build() {
        return this.sb.toString();
    }

    private void appendParam(String param, String value) {
        this.sb.append(param).append("\"").append(value).append("\"");
    }

    private String escapeTitle(String title) {
        return title.replace("-", " ").replace(":", " ").replace("?", " ").replace("~", " ").replace(WILDCARD, " ").replace("=", " ").replace(GROUP_START, " ").replace(GROUP_END, " ").trim();
    }

    private void appendGroup(List<String> entities, String paramName, Consumer<String> consumer) {
        if (entities.isEmpty()) {
            return;
        }
        this.sb.append(GROUP_START);
        this.appendParam(paramName, entities.get(0));
        List<String> other = entities.subList(1, entities.size());
        other.forEach(consumer);
        this.sb.append(GROUP_END);
    }
}

