/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.entity.StatusHistoryEvent;
import java.util.Arrays;

public class StatusHistoryHelper {
    public static final String STATUS_HISTORY_DELIMITER = ",";
    public static final String STATUS_TIMESTAMP_DELIMITER = ":";
    public static final String NOT_STARTED_STATUS_HISTORY = StatusHistoryHelper.convertToDBFormat(0);
    private static final Long NO_TIMESTAMP = null;

    public static String generateStatusHistory(int status, CourseStateEntity courseStateEntity) {
        if (courseStateEntity.getStatusHistory() == null) {
            return StatusHistoryHelper.convertToDBFormat(status);
        }
        return StatusHistoryHelper.convertToDBFormat(status) + STATUS_HISTORY_DELIMITER + courseStateEntity.getStatusHistory();
    }

    private static String convertToDBFormat(int status) {
        return status + STATUS_TIMESTAMP_DELIMITER + NO_TIMESTAMP;
    }

    public static boolean wasStartedEntity(CourseStateEntity entity) {
        return Arrays.stream(entity.getStatusHistory().split(STATUS_HISTORY_DELIMITER)).map(StatusHistoryEvent::new).anyMatch(event -> event.getStatus() == 1);
    }
}

