/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

public class SqlStringBuilder {
    private StringBuilder sql = new StringBuilder();

    private SqlStringBuilder() {
    }

    public static SqlStringBuilder sqlBuilder() {
        return new SqlStringBuilder();
    }

    public SqlStringBuilder select(String target) {
        this.sql.append("SELECT ").append(target).append(" ");
        return this;
    }

    public SqlStringBuilder from(String clause) {
        this.sql.append("FROM ").append(clause).append(" ");
        return this;
    }

    public SqlStringBuilder leftJoin(String table, String on) {
        this.sql.append("LEFT JOIN ").append(table).append(" ON ").append(on).append(" ");
        return this;
    }

    public SqlStringBuilder join(String table, String on) {
        this.sql.append("JOIN ").append(table).append(" ON ").append(on).append(" ");
        return this;
    }

    public SqlStringBuilder where(String clause) {
        this.sql.append("WHERE ").append(clause).append(" ");
        return this;
    }

    public SqlStringBuilder and(String clause) {
        this.sql.append("AND ").append(clause).append(" ");
        return this;
    }

    public SqlStringBuilder groupBy(String column) {
        this.sql.append("GROUP BY ").append(column).append(" ");
        return this;
    }

    public SqlStringBuilder in(String subSelect) {
        this.sql.append("IN (").append(subSelect).append(") ");
        return this;
    }

    public String build() {
        return this.sql.toString();
    }
}

