/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

import com.stiltsoft.confluence.quiz.utils.NumberHelper;
import java.text.DecimalFormat;

public class QuizSettingsNumberHelper {
    private static final String MASK = "###.#";

    public static String getLocalizedRate(Integer score, Integer total) {
        return new DecimalFormat(MASK).format(QuizSettingsNumberHelper.calculateRate(score, total));
    }

    public static String getLocalizedRateDetails(int score, int total) {
        return total > 0 ? String.format("%s%% (%d/%d)", QuizSettingsNumberHelper.getLocalizedRate(score, total), score, total) : "";
    }

    public static int getTimeLimit(String timeLimit) {
        return NumberHelper.getValueOrZero(timeLimit) * 1000;
    }

    public static int getAttempts(String attemptsAsString) {
        int attempts = NumberHelper.getValueOrMaxInt(attemptsAsString);
        return attempts == 0 ? Integer.MAX_VALUE : attempts;
    }

    public static int getDueDateReminder(String dueDateReminder) {
        int days = NumberHelper.getValueOrMaxInt(dueDateReminder);
        return days == 0 ? Integer.MAX_VALUE : days;
    }

    public static double calculateRate(Integer score, Integer total) {
        if (score == null || total == null || total == 0) {
            return 0.0;
        }
        return (double)(1000 * score / total) / 10.0;
    }
}

