/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(MacroParameterResolver.class);
    private static final String COURSES_PARAM = "courses";
    private static final String AUTHOR_PARAM = "author";
    private static final String EMPTY_TITLE = "";
    private static final int LIMIT_FOR_SEARCH = 1000;
    private static final String COMMA = ",";
    private static final String USERS_PARAM = "users";
    private static final String EMAILS_PARAM = "emails";
    private static final String GROUPS_PARAM = "groups";
    private static final String QUIZZES_PARAM = "quizzes";
    private static final String VERSION_PARAM = "v";
    private static final String QUIZ_SETTINGS_MACRO_NAME = "<ac:structured-macro ac:name=\"quiz-settings\"";
    private ConfluenceContentSearcher confluenceContentSearcher;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private UserAccessor userAccessor;
    private UserEntityService userEntityService;
    private GroupManager groupManager;

    public MacroParameterResolver(ConfluenceContentSearcher confluenceContentSearcher, ConfluencePermissionHelper confluencePermissionHelper, UserAccessor userAccessor, UserEntityService userEntityService, GroupManager groupManager) {
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.userAccessor = userAccessor;
        this.userEntityService = userEntityService;
        this.groupManager = groupManager;
    }

    public List<Long> resolveCoursesIds(Map<String, String> params) {
        ConfluenceUser viewer = AuthenticatedUserThreadLocal.get();
        ArrayList<Long> coursesIds = new ArrayList<Long>();
        if (params.get(AUTHOR_PARAM) != null) {
            ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(params.get(AUTHOR_PARAM)));
            AuthenticatedUserThreadLocal.set((ConfluenceUser)author);
        }
        if (params.get(COURSES_PARAM) == null || params.get(COURSES_PARAM).isEmpty()) {
            for (Searchable searchable : this.confluenceContentSearcher.findCourses(EMPTY_TITLE, 1000)) {
                coursesIds.add(searchable.getId());
            }
        } else {
            for (String id : params.get(COURSES_PARAM).split(COMMA)) {
                long pageId = Long.parseLong(id);
                if (!this.confluencePermissionHelper.canView(pageId)) continue;
                coursesIds.add(pageId);
            }
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)viewer);
        return coursesIds;
    }

    public List<Long> resolveQuizzesIds(Map<String, String> params, ContentEntityObject ceo) {
        ConfluenceUser viewer = AuthenticatedUserThreadLocal.get();
        ArrayList<Long> quizzesIds = new ArrayList<Long>();
        if (params.get(AUTHOR_PARAM) != null) {
            ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(params.get(AUTHOR_PARAM)));
            AuthenticatedUserThreadLocal.set((ConfluenceUser)author);
        }
        if (params.get(QUIZZES_PARAM) == null || params.get(QUIZZES_PARAM).isEmpty()) {
            if (params.get(VERSION_PARAM) == null && ceo.getBodyAsString().contains(QUIZ_SETTINGS_MACRO_NAME)) {
                quizzesIds.add(ceo.getId());
            } else {
                for (Searchable searchable : this.confluenceContentSearcher.findQuizzes(EMPTY_TITLE, 1000)) {
                    quizzesIds.add(searchable.getId());
                }
            }
        } else {
            for (String id : params.get(QUIZZES_PARAM).split(COMMA)) {
                long pageId = Long.parseLong(id);
                if (!this.confluencePermissionHelper.canView(pageId)) continue;
                quizzesIds.add(pageId);
            }
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)viewer);
        return quizzesIds;
    }

    public List<Integer> resolveStudentsIds(Map<String, String> params) {
        ArrayList<Integer> studentsIds = new ArrayList<Integer>();
        studentsIds.addAll(this.getStudentsIdsByUsername(params));
        studentsIds.addAll(this.getStudentsIdsByEmail(params));
        studentsIds.addAll(this.getStudentsIdsByGroups(params));
        return studentsIds;
    }

    private List<Integer> getStudentsIdsByUsername(Map<String, String> params) {
        ArrayList<Integer> studentsIdsByUsername = new ArrayList<Integer>();
        if (params.get(USERS_PARAM) != null && !params.get(USERS_PARAM).isEmpty()) {
            for (String name : params.get(USERS_PARAM).split(COMMA)) {
                ConfluenceUser student = this.userAccessor.getUserByName(name);
                if (student == null) continue;
                studentsIdsByUsername.add(this.userEntityService.getUserId(student.getKey().getStringValue()));
            }
        }
        return studentsIdsByUsername;
    }

    private List<Integer> getStudentsIdsByEmail(Map<String, String> params) {
        ArrayList<Integer> studentsIdsByEmail = new ArrayList<Integer>();
        if (params.get(EMAILS_PARAM) != null && !params.get(EMAILS_PARAM).isEmpty()) {
            for (String email : params.get(EMAILS_PARAM).split(COMMA)) {
                studentsIdsByEmail.add(this.userEntityService.getUserId(email));
            }
        }
        return studentsIdsByEmail;
    }

    private List<Integer> getStudentsIdsByGroups(Map<String, String> params) {
        ArrayList<Integer> studentIds = new ArrayList<Integer>();
        if (params.get(GROUPS_PARAM) != null && !params.get(GROUPS_PARAM).isEmpty()) {
            for (String groupName : params.get(GROUPS_PARAM).split(COMMA)) {
                try {
                    for (String studentName : this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(groupName))) {
                        ConfluenceUser student = this.userAccessor.getUserByName(studentName);
                        studentIds.add(this.userEntityService.getUserId(student.getKey().getStringValue()));
                    }
                }
                catch (EntityException e) {
                    log.error("Failed to find members of group: groupName=" + groupName, (Throwable)e);
                }
            }
        }
        return studentIds;
    }
}

