/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

import java.io.IOException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonSerializer {
    private static ObjectMapper objectMapper = JsonSerializer.createMapper();

    public static String serialize(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(String content, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }
}

