/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.cache.DateFormatterCacheManager;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DueDateHelper {
    private static final Logger log = LoggerFactory.getLogger(DueDateHelper.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).toFormatter();
    private static final long SEVEN_DAYS_IN_MILLIS = 604800000L;
    private UserAccessor userAccessor;
    private DateFormatterCacheManager dateFormatterCacheManager;

    public DueDateHelper(UserAccessor userAccessor, DateFormatterCacheManager dateFormatterCacheManager) {
        this.userAccessor = userAccessor;
        this.dateFormatterCacheManager = dateFormatterCacheManager;
    }

    public Long getCurrentUserDueDate(String dueDate, String dueDays) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.parseUserDueDate(user, dueDate, dueDays);
    }

    public Long getUserDueDate(ConfluenceUser user, String dueDate, String dueDays) {
        return this.parseUserDueDate(user, dueDate, dueDays);
    }

    public Long getUserDueDate(ConfluenceUser user, Long dueDate) {
        return this.shiftByUserTimezone(user, dueDate);
    }

    public String formatDueDate(Long dueDate) {
        if (dueDate == null) {
            return null;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.formatDateInUserTimezone(dueDate, user);
    }

    public String formatDueDate(Long dueDate, ConfluenceUser user) {
        if (dueDate == null) {
            return null;
        }
        return this.formatDateInUserTimezone(dueDate, user);
    }

    public static Long parseDueDate(String dueDate, String dueDays) {
        return DueDateHelper.convertToMillis(dueDate, dueDays, null);
    }

    public static Long parseDueDate(String dueDate, String dueDays, Long startTime) {
        return DueDateHelper.convertToMillis(dueDate, dueDays, startTime);
    }

    public static boolean isOverdue(Long dueDate) {
        return dueDate < System.currentTimeMillis();
    }

    public static boolean isUpcoming(Long dueDate) {
        return dueDate >= System.currentTimeMillis() && dueDate < System.currentTimeMillis() + 604800000L;
    }

    private static Long convertToMillis(String dueDate, String dueDays, Long startTime) {
        if (!dueDays.isEmpty()) {
            int days = Integer.parseInt(dueDays);
            if (days > 0) {
                Calendar calendar = DueDateHelper.getEndOfDay(startTime == null ? System.currentTimeMillis() : startTime);
                calendar.add(6, days - 1);
                return calendar.getTimeInMillis();
            }
        } else if (!dueDate.isEmpty()) {
            LocalDateTime ldt = LocalDateTime.parse(dueDate, DATE_TIME_FORMATTER);
            long time = ldt.atOffset(ZoneOffset.UTC).toInstant().toEpochMilli();
            Calendar calendar = DueDateHelper.getEndOfDay(time);
            return calendar.getTimeInMillis();
        }
        return null;
    }

    private static Calendar getEndOfDay(Long date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    private String formatDateInUserTimezone(long dueDate, ConfluenceUser user) {
        return this.dateFormatterCacheManager.getDateFormatter(user).format(new Date(dueDate));
    }

    private Long parseUserDueDate(ConfluenceUser user, String dueDate, String dueDays) {
        Long parsedDueDate = DueDateHelper.convertToMillis(StringUtils.defaultString((String)dueDate), StringUtils.defaultString((String)dueDays), null);
        return this.shiftByUserTimezone(user, parsedDueDate);
    }

    private Long shiftByUserTimezone(ConfluenceUser user, Long dueDate) {
        if (user != null && dueDate != null) {
            TimeZone userTimezone = this.userAccessor.getConfluenceUserPreferences((User)user).getTimeZone().getWrappedTimeZone();
            return dueDate - (long)userTimezone.getOffset(dueDate);
        }
        return dueDate;
    }
}

