/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVHelper {
    private static final Logger log = LoggerFactory.getLogger(CSVHelper.class);
    private static final char NEW_LINE = '\n';
    private static final char DELIMITER = '\t';
    private static final char QUOTE = '\"';
    private static final String ENCODING = "UTF-16LE";
    private static final char ENCODING_FLAG = '\ufeff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createCSV(String fileName, String[] headers, List<List<String>> values) {
        File csvFile = null;
        OutputStreamWriter streamWriter = null;
        CSVPrinter csvFilePrinter = null;
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withHeader(headers).withRecordSeparator('\n').withDelimiter('\t').withQuote('\"');
        try {
            csvFile = File.createTempFile(fileName, ".csv");
            streamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), Charset.forName(ENCODING).newEncoder());
            streamWriter.write(65279);
            csvFilePrinter = new CSVPrinter(streamWriter, csvFileFormat);
            csvFilePrinter.printRecords(values);
            CSVHelper.closeOutput(streamWriter, csvFilePrinter);
        }
        catch (Exception e) {
            log.error("Failed to create CSV file", (Throwable)e);
        }
        finally {
            CSVHelper.closeOutput(streamWriter, csvFilePrinter);
        }
        return csvFile;
    }

    private static void closeOutput(OutputStreamWriter streamWriter, CSVPrinter csvFilePrinter) {
        try {
            if (streamWriter != null) {
                streamWriter.flush();
                streamWriter.close();
            }
            if (csvFilePrinter != null) {
                csvFilePrinter.close();
            }
        }
        catch (IOException e) {
            log.error("Failed to close CSV file stream", (Throwable)e);
        }
    }
}

