/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizQuestionMap;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceContentSearcher.class);
    private static final int quizSearchLimit = 50;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private QuizMacroManager quizMacroManager;

    public UpgradeTask(ConfluenceContentSearcher confluenceContentSearcher, QuizMacroManager quizMacroManager) {
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.quizMacroManager = quizMacroManager;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isSame(ModelVersion.valueOf((String)"0"))) {
            ao.migrate(new Class[]{QuizQuestionMap.class});
            List<Object> quizzes = new ArrayList();
            try {
                do {
                    quizzes = this.confluenceContentSearcher.findAllQuizzes(50, quizzes.size());
                    for (AbstractPage abstractPage : quizzes) {
                        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)abstractPage);
                        for (Searchable searchable : this.confluenceContentSearcher.findQuestions(params.getLabels(), null)) {
                            QuizQuestionMap[] maps = (QuizQuestionMap[])ao.find(QuizQuestionMap.class, Query.select().where("QUIZ_ID = ? AND QUESTION_ID = ?", new Object[]{abstractPage.getId(), searchable.getId()}).limit(1));
                            if (maps.length != 0) continue;
                            ao.create(QuizQuestionMap.class, new DBParam[]{new DBParam("QUIZ_ID", (Object)abstractPage.getId()), new DBParam("QUESTION_ID", (Object)searchable.getId())});
                        }
                    }
                } while (quizzes.size() == 50);
            }
            catch (Exception e) {
                log.error("Failed to upgrage quizzes", (Throwable)e);
            }
        }
    }
}

