/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizQuestionMap;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import java.util.HashMap;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class QuestionCategoryUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final int LIMIT = 500;
    private QuizMacroManager macroManager;

    public QuestionCategoryUpgradeTask(QuizMacroManager macroManager) {
        this.macroManager = macroManager;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isSame(ModelVersion.valueOf((String)"2"))) {
            QuizQuestionMap[] maps;
            ao.migrate(new Class[]{QuizQuestionMap.class, QuestionCategory.class});
            HashMap<Long, RawEntity> quizCategoryMap = new HashMap<Long, RawEntity>();
            HashMap<Long, QuizParams> quizParamsMap = new HashMap<Long, QuizParams>();
            int offset = 0;
            do {
                for (QuizQuestionMap map : maps = (QuizQuestionMap[])ao.find(QuizQuestionMap.class, Query.select().limit(500).offset(offset).order("ID ASC"))) {
                    int position;
                    QuizParams params;
                    if (!quizCategoryMap.containsKey(map.getQuizId())) {
                        quizCategoryMap.put(map.getQuizId(), ao.create(QuestionCategory.class, new DBParam[]{new DBParam("QUIZ_ID", (Object)map.getQuizId()), new DBParam("NAME", (Object)""), new DBParam("ORDER", (Object)0)}));
                    }
                    map.setQuestionCategory((QuestionCategory)quizCategoryMap.get(map.getQuizId()));
                    map.setPosition(map.getID());
                    if (!quizParamsMap.containsKey(map.getQuizId())) {
                        quizParamsMap.put(map.getQuizId(), this.macroManager.getQuizParams(map.getQuizId()));
                    }
                    if ((params = (QuizParams)quizParamsMap.get(map.getQuizId())) != null && (position = params.getQuestionsOrder().indexOf(map.getQuestionId())) != -1) {
                        map.setPosition(position);
                    }
                    map.save();
                }
                offset += 500;
            } while (maps.length == 500);
        }
    }
}

