/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseAnswers;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.StatusHistoryHelper;
import net.java.ao.Query;

public class CourseStatusAndStatusHistoryUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final int LIMIT = 100;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"6");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isSame(ModelVersion.valueOf((String)"5"))) {
            CourseStateEntity[] entities;
            ao.migrate(new Class[]{CourseStateEntity.class});
            int offset = 0;
            do {
                for (CourseStateEntity entity : entities = (CourseStateEntity[])ao.find(CourseStateEntity.class, Query.select().limit(100).offset(offset).order("ID ASC"))) {
                    if (entity.getEnrolledDate() == null) {
                        entity.setEnrolledDate(entity.getStartDate());
                    }
                    switch (entity.getStatus()) {
                        case 4: {
                            this.migrateOverdueEntity(entity);
                            break;
                        }
                        case 0: {
                            this.migrateNotStartedEntity(entity);
                            break;
                        }
                        case 1: {
                            this.migrateStartedEntity(entity);
                            break;
                        }
                        case 3: {
                            this.migrateCancelledEntity(ao, entity);
                            break;
                        }
                        default: {
                            this.migrateFinishedEntity(entity);
                        }
                    }
                    entity.save();
                }
                offset += 100;
            } while (entities.length == 100);
        }
    }

    private void migrateOverdueEntity(CourseStateEntity entity) {
        entity.setEndDate(entity.getDueDate());
        entity.setStatusHistory(this.joinStatusHistoryEvents(this.overdueEvent(entity), this.notStartedEvent(entity)));
    }

    private String joinStatusHistoryEvents(String ... events) {
        return String.join((CharSequence)",", events);
    }

    private void migrateNotStartedEntity(CourseStateEntity entity) {
        if (this.isOverdue(entity.getDueDate())) {
            entity.setStatus(4);
            entity.setEndDate(entity.getDueDate());
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.overdueEvent(entity), this.notStartedEvent(entity)));
        } else {
            entity.setStatusHistory(this.notStartedEvent(entity));
        }
    }

    private boolean isOverdue(Long dueDate) {
        return dueDate != null && DueDateHelper.isOverdue(dueDate);
    }

    private void migrateStartedEntity(CourseStateEntity entity) {
        if (this.isOverdue(entity.getDueDate())) {
            entity.setStatus(4);
            entity.setEndDate(entity.getDueDate());
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.overdueEvent(entity), this.startedEvent(entity), this.notStartedEvent(entity)));
        } else {
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.startedEvent(entity), this.notStartedEvent(entity)));
        }
    }

    private void migrateCancelledEntity(ActiveObjects ao, CourseStateEntity entity) {
        if (this.hasAnyPassedOrFailedAnswer(ao, entity)) {
            entity.setStatus(1);
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.startedEvent(entity), this.notStartedEvent(entity)));
        } else {
            entity.setStatus(0);
            entity.setStatusHistory(this.notStartedEvent(entity));
        }
    }

    private void migrateFinishedEntity(CourseStateEntity entity) {
        if (this.isAllModulesCompleted(entity)) {
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.finishedEvent(entity), this.startedEvent(entity), this.notStartedEvent(entity)));
        } else if (entity.getDueDate() == null) {
            entity.setStatus(1);
            entity.setEndDate(null);
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.startedEvent(entity), this.notStartedEvent(entity)));
        } else {
            entity.setStatus(4);
            entity.setEndDate(entity.getDueDate());
            entity.setStatusHistory(this.joinStatusHistoryEvents(this.overdueEvent(entity), this.startedEvent(entity), this.notStartedEvent(entity)));
        }
    }

    private boolean isAllModulesCompleted(CourseStateEntity entity) {
        return entity.getCourseModules().length == 0;
    }

    private String finishedEvent(CourseStateEntity entity) {
        return StatusHistoryHelper.generateStatusHistory(2, entity);
    }

    private String overdueEvent(CourseStateEntity entity) {
        return StatusHistoryHelper.generateStatusHistory(4, entity);
    }

    private String notStartedEvent(CourseStateEntity entity) {
        return StatusHistoryHelper.generateStatusHistory(0, entity);
    }

    private String startedEvent(CourseStateEntity entity) {
        return StatusHistoryHelper.generateStatusHistory(1, entity);
    }

    private boolean hasAnyPassedOrFailedAnswer(ActiveObjects ao, CourseStateEntity entity) {
        CourseAnswers[] courseAnswers = (CourseAnswers[])ao.find(CourseAnswers.class, Query.select().where("USER_ID = ? AND COURSE_ID = ? AND AUTHOR = ? AND ATTEMPT = ? AND PASSED IS NOT NULL", new Object[]{entity.getUserId(), entity.getCourseId(), entity.getAuthor(), entity.getStartDate()}).limit(1));
        return courseAnswers.length > 0;
    }
}

