/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.entity.AttachmentParams;
import com.stiltsoft.confluence.quiz.manager.QuizAttachmentManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.servlet.MutableHttpServletRequest;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFServletFilter
extends AbstractHttpFilter {
    private static final Logger log = LoggerFactory.getLogger(PDFServletFilter.class);
    private QuizAttachmentManager quizAttachmentManager;
    private UserEntityService userEntityService;
    private UserAccessor userAccessor;

    public PDFServletFilter(QuizAttachmentManager quizAttachmentManager, UserEntityService userEntityService, UserAccessor userAccessor) {
        this.quizAttachmentManager = quizAttachmentManager;
        this.userEntityService = userEntityService;
        this.userAccessor = userAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String descriptor = request.getParameter("attachmentId").replaceAll(" ", "+");
        Long id = this.quizAttachmentManager.getAttachmentId(descriptor);
        if (id != null) {
            MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(request);
            mutableRequest.setAttribute("attachmentId", id);
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            try {
                AttachmentParams params = QuizEncrypter.decryptAttachmentParams(descriptor);
                ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(this.userEntityService.getUser(params.getAuthorId()).getKey()));
                AuthenticatedUserThreadLocal.set((ConfluenceUser)author);
                filterChain.doFilter((ServletRequest)mutableRequest, (ServletResponse)response);
            }
            catch (Exception e) {
                log.error("ATTACHMENT ERROR: Failed to parse descriptor", (Throwable)e);
            }
            finally {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
            }
            return;
        }
        log.warn(String.format("ATTACHMENT ERROR: PDF_ATTACHMENT_ID IS NULL, descriptor=%s", descriptor));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

