/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.servlet;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.plugins.conversion.convert.ConversionException;
import com.atlassian.plugins.conversion.convert.FileFormat;
import com.atlassian.plugins.conversion.convert.image.CellsConverter;
import com.atlassian.plugins.conversion.convert.image.ImagingConverter;
import com.atlassian.plugins.conversion.convert.image.SlidesConverter;
import com.atlassian.plugins.conversion.convert.image.WordsConverter;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.cache.AttachmentsCacheManager;
import com.stiltsoft.confluence.quiz.manager.QuizAttachmentManager;
import com.stiltsoft.confluence.quiz.servlet.AbstractAttachmentServlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionThumbnailServlet
extends AbstractAttachmentServlet {
    private static final Logger log = LoggerFactory.getLogger(ConversionThumbnailServlet.class);
    private ImagingConverter imagingConverter;
    private SlidesConverter slidesConverter;
    private WordsConverter wordsConverter;
    private CellsConverter cellsConverter;

    public ConversionThumbnailServlet(AttachmentManager attachmentManager, AttachmentsCacheManager cacheManager, QuizService quizService, QuizAttachmentManager quizAttachmentManager, ImagingConverter imagingConverter, SlidesConverter slidesConverter, WordsConverter wordsConverter, CellsConverter cellsConverter) {
        super(attachmentManager, cacheManager, quizService, quizAttachmentManager);
        this.imagingConverter = imagingConverter;
        this.slidesConverter = slidesConverter;
        this.wordsConverter = wordsConverter;
        this.cellsConverter = cellsConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String descriptor = request.getRequestURI().split("conversion/thumbnail/")[1];
        Long id = this.quizAttachmentManager.getAttachmentId(descriptor = descriptor.substring(0, descriptor.lastIndexOf("/")));
        if (id == null) {
            log.warn(String.format("ATTACHMENT ERROR: THUMBNAIL_ATTACHMENT_ID  IS NULL descriptor=%s", descriptor));
            return;
        }
        Attachment attachment = this.attachmentManager.getAttachment(id.longValue());
        FileFormat fileFormat = FileFormat.fromMimeType((String)attachment.getContentType());
        InputStream stream = this.attachmentManager.getAttachmentData(attachment);
        ServletOutputStream output = response.getOutputStream();
        response.setContentType("image/jpg");
        try {
            if (fileFormat.equals((Object)FileFormat.PPT) || fileFormat.equals((Object)FileFormat.PPTX)) {
                this.slidesConverter.generateThumbnailDirect(fileFormat, FileFormat.JPG, stream, (OutputStream)output, 1, 1000.0, 2050.0);
            } else if (fileFormat.equals((Object)FileFormat.DOC) || fileFormat.equals((Object)FileFormat.DOCX)) {
                this.wordsConverter.generateThumbnailDirect(fileFormat, FileFormat.JPG, stream, (OutputStream)output, 1, 1000.0, 2050.0);
            } else if (fileFormat.equals((Object)FileFormat.XLS) || fileFormat.equals((Object)FileFormat.XLSX)) {
                this.cellsConverter.generateThumbnailDirect(fileFormat, FileFormat.JPG, stream, (OutputStream)output, 1, 1000.0, 2050.0);
            } else {
                this.imagingConverter.generateThumbnailDirect(fileFormat, FileFormat.JPG, stream, (OutputStream)output, 1, 1000.0, 2050.0);
            }
        }
        catch (ConversionException e) {
            log.error("ATTACHMENT ERROR: Failed to create thumbnail", (Throwable)e);
        }
        finally {
            stream.close();
            output.flush();
            output.close();
        }
    }
}

