/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.servlet;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.cache.AttachmentsCacheManager;
import com.stiltsoft.confluence.quiz.manager.QuizAttachmentManager;
import com.stiltsoft.confluence.quiz.servlet.AbstractAttachmentServlet;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentServlet
extends AbstractAttachmentServlet {
    private static final Logger log = LoggerFactory.getLogger(AttachmentServlet.class);
    private static final String MP4 = "mp4";

    public AttachmentServlet(AttachmentManager attachmentManager, AttachmentsCacheManager cacheManager, QuizService quizService, QuizAttachmentManager quizAttachmentManager) {
        super(attachmentManager, cacheManager, quizService, quizAttachmentManager);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getRequestURI().replace("/plugins/servlet/quiz", "");
        url = url + "?" + request.getQueryString();
        url = url.replace("/download/thumbnails/", "/download/attachments/");
        String descriptor = url.split("/download/attachments/")[1];
        Long id = this.quizAttachmentManager.getAttachmentId(descriptor = descriptor.substring(0, descriptor.lastIndexOf("/")));
        if (id == null) {
            log.warn(String.format("ATTACHMENT ERROR: ATTACHMENT_ID IS NULL descriptor=%s", descriptor));
            return;
        }
        url = url.replace(descriptor, this.quizAttachmentManager.getUrlParam(descriptor));
        Attachment attachment = (Attachment)this.attachmentManager.getAttachmentForDownloadPath(url).get();
        InputStream stream = this.attachmentManager.getAttachmentData(attachment);
        response.setContentType(attachment.getContentType());
        if (MP4.equalsIgnoreCase(attachment.getFileExtension())) {
            response.addHeader("Accept-Ranges", "bytes");
            long attachmentFileSize = attachment.getFileSize();
            response.addHeader("Content-Length", Long.toString(attachmentFileSize));
            response.addHeader("Content-Range", "bytes 0-" + (attachmentFileSize - 1L) + "/" + attachmentFileSize);
        }
        byte[] buffer = new byte[10240];
        ServletOutputStream output = response.getOutputStream();
        int length = 0;
        while ((length = stream.read(buffer)) > 0) {
            output.write(buffer, 0, length);
        }
        stream.close();
        output.flush();
        output.close();
    }
}

