/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.service.course;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.entity.course.CourseMetadata;
import com.stiltsoft.confluence.quiz.service.course.CourseMetadataService;

public class DefaultCourseMetadataService
implements CourseMetadataService {
    private PageManager pageManager;
    private CourseSettingsService settingsService;

    public DefaultCourseMetadataService(PageManager pageManager, CourseSettingsService settingsService) {
        this.pageManager = pageManager;
        this.settingsService = settingsService;
    }

    @Override
    public CourseMetadata getCourseMetadata(Long courseId) {
        CourseSettings courseSettings = this.settingsService.getOrCreate(courseId);
        return this.getMetadata(courseSettings);
    }

    @Override
    public CourseMetadata getCourseMetadata(CourseSettings courseSettings) {
        return this.getMetadata(courseSettings);
    }

    private CourseMetadata getMetadata(CourseSettings courseSettings) {
        AbstractPage page = this.pageManager.getAbstractPage(courseSettings.getCourseId().longValue());
        if (page != null && !page.isDeleted()) {
            return new CourseMetadata(page, courseSettings);
        }
        return null;
    }
}

