/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.ao.entity.settings.AbstractPermission;
import com.stiltsoft.confluence.quiz.ao.service.settings.CQPermissionService;
import com.stiltsoft.confluence.quiz.ao.service.settings.CoauthorService;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="settings")
public class SettingsRest {
    private static final Logger log = LoggerFactory.getLogger(SettingsRest.class);
    private CQPermissionService cqPermissionService;
    private CoauthorService coauthorService;
    private PermissionManager permissionManager;
    private CQPermissionHelper cqPermissionHelper;
    private LicenseManager licenseManager;

    public SettingsRest(CQPermissionService cqPermissionService, CoauthorService coauthorService, PermissionManager permissionManager, CQPermissionHelper cqPermissionHelper, LicenseManager licenseManager) {
        this.cqPermissionService = cqPermissionService;
        this.permissionManager = permissionManager;
        this.coauthorService = coauthorService;
        this.cqPermissionHelper = cqPermissionHelper;
        this.licenseManager = licenseManager;
    }

    @POST
    @Path(value="permissions")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setGlobalPermissions(@FormParam(value="groups") List<String> groups, @FormParam(value="users") List<String> users) {
        if (this.isConfluenceAdmin()) {
            this.cqPermissionService.setGroups(groups, AbstractPermission.CREATE);
            this.cqPermissionService.setUsers(users, AbstractPermission.CREATE);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="coauthors")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setCoauthors(@FormParam(value="groups") List<String> groups, @FormParam(value="users") List<String> users) {
        if (this.isConfluenceAdmin()) {
            this.coauthorService.setCoauthors(groups, users);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="check-user-access-to-cq-entities")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response checkUserAccessToCQEntities() {
        return Response.ok((Object)this.cqPermissionHelper.isUserHasAccessToCQEntities()).build();
    }

    @GET
    @Path(value="check-dc-license")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response checkDcLicense() {
        return Response.ok((Object)this.licenseManager.isDataCenter()).build();
    }

    private boolean isConfluenceAdmin() {
        return this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
    }
}

