/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.ReminderService;
import com.stiltsoft.confluence.quiz.entity.DueDateChanges;
import com.stiltsoft.confluence.quiz.entity.EnrollResult;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.QuizReminderMessages;
import com.stiltsoft.confluence.quiz.entity.SearchResult;
import com.stiltsoft.confluence.quiz.entity.SingleValueResponse;
import com.stiltsoft.confluence.quiz.entity.Status;
import com.stiltsoft.confluence.quiz.entity.UserRestEntity;
import com.stiltsoft.confluence.quiz.entity.UserWithAttempts;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.Result;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.AnswersReport;
import com.stiltsoft.confluence.quiz.mail.MailSender;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.ParticipantsHelper;
import com.stiltsoft.confluence.quiz.manager.QuizAnswersHelper;
import com.stiltsoft.confluence.quiz.manager.QuizHelper;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.ReminderController;
import com.stiltsoft.confluence.quiz.manager.UpdateMacroManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.CSVHelper;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import com.stiltsoft.confluence.quiz.utils.QuizSettingsNumberHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="service")
public class QuizRest {
    private static final Logger log = LoggerFactory.getLogger(QuizRest.class);
    private QuizService quizService;
    private UserEntityService userEntityService;
    private UserAccessor userAccessor;
    private ParticipantsHelper participantsHelper;
    private PageManager pageManager;
    private QuizMacroManager quizMacroManager;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private MailSender mailSender;
    private LicenseManager licenseManager;
    private MailServerManager mailServerManager;
    private UpdateMacroManager updateMacroManager;
    private CQPermissionHelper cqPermissionHelper;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private DueDateHelper dueDateHelper;
    private QuizHelper quizHelper;
    private QuizAnswersHelper quizAnswersHelper;
    private I18nResolver i18n;
    private ReminderController reminderController;
    private SettingsManager settingsManager;
    private ReminderService reminderService;

    public QuizRest(QuizService quizService, UserEntityService userEntityService, UserAccessor userAccessor, ParticipantsHelper participantsHelper, PageManager pageManager, QuizMacroManager quizMacroManager, ConfluenceContentSearcher confluenceContentSearcher, MailSender mailSender, LicenseManager licenseManager, MailServerManager mailServerManager, UpdateMacroManager updateMacroManager, CQPermissionHelper cqPermissionHelper, ConfluencePermissionHelper confluencePermissionHelper, DueDateHelper dueDateHelper, QuizHelper quizHelper, QuizAnswersHelper quizAnswersHelper, I18nResolver i18n, ReminderController reminderController, SettingsManager settingsManager, ReminderService reminderService) {
        this.quizService = quizService;
        this.userEntityService = userEntityService;
        this.userAccessor = userAccessor;
        this.participantsHelper = participantsHelper;
        this.pageManager = pageManager;
        this.quizMacroManager = quizMacroManager;
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.mailSender = mailSender;
        this.licenseManager = licenseManager;
        this.mailServerManager = mailServerManager;
        this.updateMacroManager = updateMacroManager;
        this.cqPermissionHelper = cqPermissionHelper;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.dueDateHelper = dueDateHelper;
        this.quizHelper = quizHelper;
        this.quizAnswersHelper = quizAnswersHelper;
        this.i18n = i18n;
        this.reminderController = reminderController;
        this.settingsManager = settingsManager;
        this.reminderService = reminderService;
    }

    @GET
    @Path(value="mail-server")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response isMailServer() {
        return Response.ok((Object)this.mailServerManager.isDefaultSMTPMailServerDefined()).build();
    }

    @POST
    @Path(value="settings")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateSettings(@FormParam(value="pageId") Long pageId, @FormParam(value="type") String type, @FormParam(value="value") String value, @FormParam(value="updateEnrolled") Boolean updateEnrolled) throws Exception {
        Page page = this.pageManager.getPage(pageId.longValue());
        if (!this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(type, value);
        this.updateMacroManager.updateParams(pageId, "quiz-settings", params);
        if (updateEnrolled != null && updateEnrolled.booleanValue()) {
            if ("attempts".equals(type)) {
                int attempts = QuizSettingsNumberHelper.getAttempts(value);
                for (Map.Entry<QuizStateEntity, Integer> updatedEntity : this.quizService.updateAttempts(pageId, attempts).entrySet()) {
                    this.sendAttemptsAdded(Lists.newArrayList((Object[])new QuizStateEntity[]{updatedEntity.getKey()}), page, updatedEntity.getValue());
                }
            } else if ("due-date".equals(type) || "due-days".equals(type)) {
                String dueDate = "due-date".equals(type) ? StringUtils.defaultString((String)value) : "";
                String dueDays = "due-days".equals(type) ? StringUtils.defaultString((String)value) : "";
                this.sendDueDateUpdated(this.quizService.updateDueDate(pageId, dueDate, dueDays), page);
            } else if ("enrollment-reminder".equals(type)) {
                Integer daysAfterEnrollment = "".equals(value) ? null : Integer.valueOf(value);
                this.reminderService.updateQuizDAEReminders(pageId, daysAfterEnrollment);
            } else if ("duedate-reminder".equals(type)) {
                Integer daysBeforeDueDate = "".equals(value) ? null : Integer.valueOf(value);
                this.reminderService.updateQuizDueDateReminders(pageId, daysBeforeDueDate);
            }
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="settings/reminder-messages")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getReminderMessages(@QueryParam(value="pageId") Long pageId) throws XhtmlException {
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null || page.isDeleted() || !this.confluencePermissionHelper.canView((ContentEntityObject)page)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        QuizParams quizParams = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
        return Response.ok((Object)new QuizReminderMessages(quizParams.getEnrollmentReminderMsg(), quizParams.getDueDateReminderMsg())).build();
    }

    @POST
    @Path(value="test")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setTest(@FormParam(value="pageId") Long pageId, @FormParam(value="text") String text, @FormParam(value="count") String questionsCount, @FormParam(value="target") String answersTarget, @FormParam(value="timelimit") String timeLimit, @FormParam(value="attempts") String attempts, @FormParam(value="showRes") String showResult, @FormParam(value="showFeedback") String showFeedback, @FormParam(value="random") String randomize, @FormParam(value="skip") String skip, @FormParam(value="resubmit") String resubmit, @FormParam(value="users") List<String> users, @FormParam(value="groups") List<String> groups, @FormParam(value="emails") List<String> emails) throws Exception {
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        Page page = this.pageManager.getPage(pageId.longValue());
        if (!this.confluencePermissionHelper.canView((ContentEntityObject)page) || !this.licenseManager.isActive()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Set<ConfluenceUser> participants = this.participantsHelper.getParticipants(users, groups, emails);
        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
        params.setCount(questionsCount);
        params.setTarget(answersTarget);
        params.setTimeLimit(timeLimit);
        params.setAttempts(attempts);
        params.setShowRes(showResult);
        params.setShowFeedback(showFeedback);
        params.setSkip(skip);
        params.setResubmit(resubmit);
        params.setRandom(randomize);
        params.setDesc(text);
        List<AbstractPage> results = this.confluenceContentSearcher.findStructuredQuestions(page.getId(), author).getQuestions();
        ArrayList<UserWithAttempts> userRestEntities = new ArrayList<UserWithAttempts>();
        ArrayList<ConfluenceUser> participantsToEnroll = new ArrayList<ConfluenceUser>();
        Set<Integer> enrolledUserIds = this.quizService.getQuizActualEnrolledUserIds(pageId);
        for (ConfluenceUser participant : participants) {
            if (enrolledUserIds.contains(this.userEntityService.getUserId(participant.getKey().getStringValue()))) {
                QuizStateEntity entity = this.quizService.getUserActualStates(participant.getKey().getStringValue(), pageId).get(0);
                if (participant.getName() != null) {
                    userRestEntities.add(new UserWithAttempts(participant.getKey().getStringValue(), participant.getName(), participant.getFullName(), "", entity.getAttempts(), entity.getAttemptsCount()));
                    continue;
                }
                userRestEntities.add(new UserWithAttempts(participant.getKey().getStringValue(), participant.getKey().getStringValue(), participant.getKey().getStringValue(), "email", entity.getAttempts(), entity.getAttemptsCount()));
                continue;
            }
            participantsToEnroll.add(participant);
        }
        this.quizHelper.enroll(params, results, participantsToEnroll, page, author);
        return Response.ok(new EnrollResult(participantsToEnroll.size(), userRestEntities)).build();
    }

    @GET
    @Path(value="email")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getMails(@QueryParam(value="max-results") Integer limit, @QueryParam(value="query") String query) {
        if (AuthenticatedUserThreadLocal.get() == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok(this.userEntityService.getEmails(query, limit)).build();
    }

    @POST
    @Path(value="test/start")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response startTest(@FormParam(value="param") String param) throws Exception {
        MailParams params = this.getParams(param);
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Optional<QuizStateEntity> quizStateEntityOpt = this.quizService.getState(params.getUid(), params.getQid(), params.getRid());
        if (!quizStateEntityOpt.isPresent() || Boolean.TRUE.equals(quizStateEntityOpt.get().getDeleted())) {
            return Response.ok((Object)new SingleValueResponse("ENROLL_NOT_FOUND")).build();
        }
        boolean isStarted = this.quizService.startTest(quizStateEntityOpt.get());
        return Response.ok((Object)new SingleValueResponse(isStarted ? "STARTED" : "NOT_STARTED")).build();
    }

    @POST
    @Path(value="test/restart")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response restartTest(@FormParam(value="param") String param) throws Exception {
        MailParams params = this.getParams(param);
        Page page = this.pageManager.getPage(params.getQid().longValue());
        QuizParams quizParams = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
        ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(this.userEntityService.getUser(params.getAid()).getKey()));
        List<AbstractPage> results = this.confluenceContentSearcher.findStructuredQuestions(page.getId(), author).getQuestions();
        List<Long> questions = this.quizHelper.getQuestionsSet(quizParams, results);
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Optional<QuizStateEntity> previousAttemptOpt = this.quizService.getState(params.getUid(), params.getQid(), params.getRid());
        if (!previousAttemptOpt.isPresent() || Boolean.TRUE.equals(previousAttemptOpt.get().getDeleted())) {
            return Response.ok((Object)new SingleValueResponse("ENROLL_NOT_FOUND")).build();
        }
        Optional<QuizStateEntity> entityOpt = this.quizService.restartTest(params.getUid(), params.getQid(), params.getAid(), questions, previousAttemptOpt.get(), quizParams);
        if (entityOpt.isPresent()) {
            QuizStateEntity entity = entityOpt.get();
            Integer sessionId = entity.getSessionId() != null ? entity.getSessionId().intValue() : entity.getID();
            return Response.ok((Object)new SingleValueResponse(GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(params.getQid(), params.getUid(), params.getAid(), params.getKey(), sessionId))))).build();
        }
        return Response.ok((Object)new SingleValueResponse("QUIZ_ENROLL_NOT_RESTARTED")).build();
    }

    @POST
    @Path(value="answer")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response saveAnswer(@FormParam(value="param") String param, @FormParam(value="pid") Long pid, @FormParam(value="attempt") Long attempt, @FormParam(value="started") Long started, @FormParam(value="answers") List<String> answers, @FormParam(value="isAutoCheckedFreeText") Boolean isAutoCheckedFreeText) throws Exception {
        MailParams params = this.getParams(param);
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return Response.serverError().build();
        }
        QuizStateEntity entity = this.quizService.finishTestTx(params.getUid(), params.getQid(), params.getAid(), params.getRid(), false);
        if (entity == null || Boolean.TRUE.equals(entity.getDeleted())) {
            return Response.ok((Object)new Result("ENROLL_NOT_FOUND")).build();
        }
        if (entity.getStatus() == 2) {
            return Response.ok((Object)new Result(entity.getCorrect(), false, false, entity.getReview() != null && entity.getReview() > 0, false, entity.getAnswers())).build();
        }
        MutablePair<QuizStateEntity, QuizAnswersEntity> entityPair = this.quizService.saveAnswer(params.getUid(), params.getQid(), params.getAid(), pid, attempt, answers, params.getRid(), started, isAutoCheckedFreeText);
        if (entityPair == null) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        entity = (QuizStateEntity)entityPair.getLeft();
        this.quizHelper.notifyOnCompletion(entity);
        boolean showFeedback = Boolean.TRUE.equals(entity.getShowFeedback());
        return Response.ok((Object)new Result(entity.getStatus() == 2 ? entity.getCorrect() : -1, entity.getShowRes(), entity.getShowRes() != false && Boolean.TRUE.equals(((QuizAnswersEntity)entityPair.getRight()).getCorrect()), Boolean.TRUE.equals(((QuizAnswersEntity)entityPair.getRight()).getReviewable()), showFeedback, entity.getAnswers())).build();
    }

    @POST
    @Path(value="skip")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response skip(@FormParam(value="param") String param, @FormParam(value="pid") Long pid, @FormParam(value="nextId") Long nextId, @FormParam(value="attempt") Long attempt) throws Exception {
        MailParams params = this.getParams(param);
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return Response.serverError().build();
        }
        this.quizService.skipQuestion(params.getUid(), params.getQid(), params.getAid(), pid, attempt, params.getRid(), nextId);
        return Response.ok().build();
    }

    @POST
    @Path(value="finish")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response finishTest(@FormParam(value="param") String param, @FormParam(value="giveUp") Boolean giveUp) throws Exception {
        MailParams params = this.getParams(param);
        if (!this.cqPermissionHelper.isUserAuthorized(params)) {
            return Response.serverError().build();
        }
        QuizStateEntity quizStateEntity = this.quizService.finishTestTx(params.getUid(), params.getQid(), params.getAid(), params.getRid(), giveUp);
        if (quizStateEntity == null || Boolean.TRUE.equals(quizStateEntity.getDeleted())) {
            return Response.ok((Object)new SingleValueResponse("ENROLL_NOT_FOUND")).build();
        }
        return Response.ok((Object)new SingleValueResponse("FINISHED")).build();
    }

    @POST
    @Path(value="answers/remove")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeAnswers(@FormParam(value="pageId") Long pageId, @FormParam(value="ids") List<Integer> ids) {
        if (pageId != null) {
            Page page = this.pageManager.getPage(pageId.longValue());
            if (page == null || page.isDeleted() || !this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.quizService.delete(pageId, ids);
        } else {
            this.quizService.deleteByUser(AuthenticatedUserThreadLocal.get().getKey().getStringValue(), ids);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="search/quizzes")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response searchQuizzes(@QueryParam(value="title") String title, @QueryParam(value="limit") Integer limit, @QueryParam(value="restrictedIds") List<Long> restrictedIds) {
        List<AbstractPage> results = this.confluenceContentSearcher.findQuizzes(title, limit == null ? 10 : limit, restrictedIds);
        return Response.ok(this.convertToSearchResults(results)).build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="search/questions")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response searchQuestions(@FormParam(value="title") String title, @FormParam(value="restrictedIds") List<Long> restrictedIds) {
        List<AbstractPage> results = this.confluenceContentSearcher.findStructuredQuestions(title, 6, restrictedIds);
        return Response.ok(this.convertToSearchResults(results)).build();
    }

    @GET
    @Path(value="search/pages")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response searchPages(@QueryParam(value="title") String title, @QueryParam(value="limit") Integer limit, @QueryParam(value="restrictedIds") List<Long> restrictedIds) {
        List<AbstractPage> results = this.confluenceContentSearcher.findPages(title, limit == null ? 10 : limit, restrictedIds);
        return Response.ok(this.convertToSearchResults(results)).build();
    }

    @GET
    @Path(value="get/questions")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getQuestions(@QueryParam(value="id") Long id) {
        List<AbstractPage> results = this.confluenceContentSearcher.findStructuredQuestions(id, AuthenticatedUserThreadLocal.get()).getQuestions();
        return Response.ok(this.convertToSearchResults(results)).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="take/quiz")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response takeQuiz(@QueryParam(value="pageId") Long pageId, @QueryParam(value="author") String authorKey, @QueryParam(value="mail") String mail, @QueryParam(value="name") String name) throws Exception {
        boolean anonymousEmailConfirmation;
        if (!this.licenseManager.isActive()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        Page page = this.pageManager.getPage(pageId.longValue());
        ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(authorKey));
        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
        if (params.getDueDate() != null && DueDateHelper.isOverdue(params.getDueDate())) {
            return Response.ok((Object)"\"overdue\"").build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String userKey = mail;
        if (user != null) {
            userKey = user.getKey().getStringValue();
            mail = user.getEmail();
        } else if (mail.isEmpty() || name.isEmpty()) {
            if (!params.isAnonymous()) return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            userKey = "Participant " + (this.userEntityService.getUsersCount() + 1);
        } else {
            Pager pager = this.userAccessor.getUsersByEmail(mail).pager();
            if (!pager.isEmpty()) {
                pager.getCurrentPage().get(0);
                ConfluenceUser student = this.userAccessor.getUserByName(((com.atlassian.crowd.embedded.api.User)pager.getCurrentPage().get(0)).getName());
                userKey = student.getKey().getStringValue();
            }
        }
        int userId = this.userEntityService.getUserId(userKey, name);
        int authorId = this.userEntityService.getUserId(author.getKey().getStringValue());
        List<QuizStateEntity> entities = this.quizService.getUserActualStates(userKey, pageId);
        if (entities.size() > 0) {
            for (QuizStateEntity entity : entities) {
                int sessionId;
                if (!Status.isActive(entity) && (entity.getAttempts() == null || entity.getAttempts() <= 0)) continue;
                int n = sessionId = entity.getSessionId() == null ? entity.getID() : entity.getSessionId().intValue();
                if (mail.isEmpty() || user != null) return Response.ok((Object)("{\"url\": \"/quiz/test/view.action?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, authorId, userKey, sessionId))) + "\"}")).build();
                String formattedDueDate = this.dueDateHelper.formatDueDate(entity.getDueDate());
                this.mailSender.send(mail, userKey, page, userId, author, authorId, params.getDesc(), sessionId, true, formattedDueDate);
                return Response.ok((Object)("{\"url\": \"/quiz/test/view.action?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, authorId, userKey, sessionId))) + "\"}")).build();
            }
            return Response.ok((Object)"\"no-attempts\"").build();
        }
        List<AbstractPage> results = this.confluenceContentSearcher.findStructuredQuestions(page.getId(), author).getQuestions();
        Integer recordId = this.quizHelper.createQuizRecord(params, results, user, userKey, mail, name, page, author, true);
        boolean bl = anonymousEmailConfirmation = params.isAnonymousConfirmation() || params.isAnonymous();
        if (!anonymousEmailConfirmation && user == null) return Response.ok().build();
        return Response.ok((Object)("{\"url\": \"/quiz/test/view.action?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(page.getId(), userId, authorId, userKey, recordId))) + "\"}")).build();
    }

    @POST
    @Path(value="answer/review")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response reviewAnswer(@FormParam(value="correct") Boolean correct, @FormParam(value="stateId") Integer stateId, @FormParam(value="qid") Long qid, @FormParam(value="uid") Integer uid, @FormParam(value="attempt") Long attempt, @FormParam(value="pageId") Long pageId) throws Exception {
        if (!this.confluencePermissionHelper.canView(qid)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ConfluenceUser reviewer = AuthenticatedUserThreadLocal.get();
        int prevReview = this.quizService.getStateTx(stateId).getReview();
        QuizStateEntity entity = this.quizService.reviewAnswer(uid, qid, pageId, attempt, correct, stateId, reviewer.getKey().getStringValue());
        if (entity != null && entity.getReview() == 0 && entity.getStatus() == 2) {
            String email;
            UserEntity user = this.userEntityService.getUser(uid);
            String userKey = user.getKey();
            ConfluenceUser student = null;
            if (user.getExternal().booleanValue()) {
                email = user.getKey();
            } else {
                student = this.userAccessor.getUserByKey(new UserKey(userKey));
                email = student.getEmail();
            }
            Page page = this.pageManager.getPage(qid.longValue());
            Page coursePage = entity.getCourseId() != null ? this.pageManager.getPage(entity.getCourseId().longValue()) : null;
            QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)page);
            if (!params.isDisableUserNotification()) {
                this.mailSender.sendReviewed(email, userKey, page, reviewer, entity, prevReview, coursePage, params);
            }
            List<String> keys = params.getAuthorsKeys();
            keys.remove(reviewer.getKey().getStringValue());
            for (String key : keys) {
                ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(key));
                this.mailSender.sendReviewedAuthors(student == null ? email : student.getFullName(), reviewer, author, page, entity, prevReview, coursePage);
            }
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="users/get")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getUsers(@QueryParam(value="keys") List<String> keys) {
        ArrayList<UserRestEntity> entities = new ArrayList<UserRestEntity>();
        for (String key : keys) {
            ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(key));
            entities.add(new UserRestEntity(key, user.getName(), user.getFullName(), this.userAccessor.getUserProfilePicture((User)user).getDownloadPath()));
        }
        return Response.ok(entities).build();
    }

    @GET
    @Path(value="current-user-key")
    @XsrfProtectionExcluded
    @Produces(value={"text/plain"})
    public Response getCurrentUserKey() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return Response.ok((Object)(user == null ? "" : user.getKey().getStringValue())).build();
    }

    @POST
    @Path(value="remove-imports")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeImports(@FormParam(value="ids") List<Long> ids) {
        for (Long id : ids) {
            Page page = this.pageManager.getPage(id.longValue());
            if (!this.confluencePermissionHelper.canRemove((ContentEntityObject)page)) continue;
            this.pageManager.removeContentEntity((ContentEntityObject)page);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="users/add-attempts")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addUsersAttempts(@FormParam(value="keys") List<String> keys, @FormParam(value="attempts") Integer attempts, @FormParam(value="quizId") Long quizId) {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            this.sendAttemptsAdded(this.quizService.addUsersAttempts(quizId, attempts, keys), page, attempts);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="records/add-attempts")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addRecordsAttempts(@FormParam(value="ids") List<Integer> ids, @FormParam(value="attempts") Integer attempts, @FormParam(value="quizId") Long quizId) {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            this.sendAttemptsAdded(this.quizService.addRecordsAttempts(quizId, attempts, ids), page, attempts);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="records/update-due-date")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addRecordsAttempts(@FormParam(value="ids") List<Integer> ids, @FormParam(value="dueDate") String dueDate, @FormParam(value="dueDays") String dueDays, @FormParam(value="quizId") Long quizId) {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            this.sendDueDateUpdated(this.quizService.updateDueDate(quizId, StringUtils.defaultString((String)dueDate), StringUtils.defaultString((String)dueDays), ids), page);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="remind")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response remind(@FormParam(value="quizId") Long quizId, @FormParam(value="message") String message) {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            ConfluenceUser author = AuthenticatedUserThreadLocal.get();
            List<QuizStateEntity> entities = this.quizService.getStates(quizId, new ArrayList<Integer>());
            this.reminderController.sendReminders(entities, author, message, page);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="can-edit-quizzes")
    @XsrfProtectionExcluded
    @Produces(value={"text/plain"})
    public Response canEditQuizzes(@QueryParam(value="ids") List<Long> ids, @QueryParam(value="author") String authorKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Boolean canEdit = true;
        if (ids == null || ids.isEmpty()) {
            ids = new ArrayList<Long>();
            ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(authorKey));
            AuthenticatedUserThreadLocal.set((ConfluenceUser)author);
            for (Searchable searchable : this.confluenceContentSearcher.findQuizzes("", 1000)) {
                ids.add(searchable.getId());
            }
            AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        }
        for (Long id : ids) {
            if (this.confluencePermissionHelper.canView(id)) continue;
            canEdit = false;
            break;
        }
        return Response.ok((Object)canEdit.toString()).build();
    }

    @GET
    @Path(value="exportCSV")
    @XsrfProtectionExcluded
    @AnonymousAllowed
    @Produces(value={"application/csv"})
    public Response exportReportToCSV(@Context HttpServletResponse response, @QueryParam(value="pageId") Long pageId, @QueryParam(value="pageVersion") Integer pageVersion, @QueryParam(value="macroId") String macroId) throws IOException, URISyntaxException {
        if (!this.licenseManager.isActive()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (!this.confluencePermissionHelper.canView(pageId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page == null || page.isDeleted()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AbstractPage version = this.pageManager.getPageByVersion(page, pageVersion.intValue());
        if (version == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<Map<String, String>> paramsOpt = this.quizMacroManager.getQuizAnswersReportParams((ContentEntityObject)version, macroId);
        if (!paramsOpt.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AnswersReport report = this.quizAnswersHelper.buildReport(paramsOpt.get(), (ContentEntityObject)version);
        List<String> headers = report.getHeaders(this.i18n);
        List<List<String>> records = report.getValues(this.i18n);
        File csvFile = CSVHelper.createCSV("quiz-results", headers.toArray(new String[0]), records);
        if (csvFile != null) {
            response.setContentLength(Long.valueOf(csvFile.length()).intValue());
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename*=utf-8''" + URLEncoder.encode("quiz-results.csv", "UTF-8"));
            Cookie cookie = new Cookie("quiz-csv", "true");
            String url = this.settingsManager.getGlobalSettings().getBaseUrl();
            URI uri = new URI(url);
            String domain = uri.getHost();
            cookie.setMaxAge(5);
            cookie.setPath("/");
            cookie.setDomain(domain);
            response.addCookie(cookie);
            response.flushBuffer();
            FileInputStream inputStream = new FileInputStream(csvFile);
            byte[] resource = new byte[(int)csvFile.length()];
            inputStream.read(resource);
            inputStream.close();
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(resource);
            outputStream.flush();
            outputStream.close();
            csvFile.delete();
        }
        return Response.ok().build();
    }

    private MailParams getParams(String param) throws Exception {
        return QuizEncrypter.decrypt(GeneralUtil.urlDecode((String)param));
    }

    private List<SearchResult> convertToSearchResults(List<AbstractPage> results) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        for (AbstractPage page : results) {
            searchResults.add(new SearchResult(page.getId(), page.getDisplayTitle()));
        }
        return searchResults;
    }

    private void sendAttemptsAdded(List<QuizStateEntity> entities, Page page, int attempts) {
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        for (QuizStateEntity entity : entities) {
            try {
                this.mailSender.sendAttemptsAdded(entity, page, author, attempts);
            }
            catch (Exception e) {
                log.error("Failed to send quiz notification", (Throwable)e);
            }
        }
    }

    private void sendDueDateUpdated(Map<QuizStateEntity, DueDateChanges> map, Page page) {
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        for (Map.Entry<QuizStateEntity, DueDateChanges> updatedEntity : map.entrySet()) {
            try {
                if (updatedEntity.getKey().getStatus() == 2) continue;
                this.mailSender.sendDueDateUpdated(updatedEntity.getKey(), page, author, updatedEntity.getValue());
            }
            catch (Exception e) {
                log.error("Failed to send quiz notification", (Throwable)e);
            }
        }
    }
}

