/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.renderer.RenderContext;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuestionCategoryService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizQuestionMapService;
import com.stiltsoft.confluence.quiz.entity.ParentPage;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionsStats;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.QuestionStatsHelper;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.QuizMediaInserter;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.manager.UpdateMacroManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="quiz-question")
public class QuestionRest {
    private PageManager pageManager;
    private QuizMacroManager quizMacroManager;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;
    private QuizPageManager quizPageManager;
    private QuizMediaInserter quizMediaInserter;
    private LabelManager labelManager;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private QuizQuestionMapService quizQuestionMapService;
    private UpdateMacroManager updateMacroManager;
    private QuestionCategoryService categoryService;
    private QuestionStatsHelper statsHelper;
    private SoyTemplateRenderer soyTemplateRenderer;

    public QuestionRest(PageManager pageManager, QuizMacroManager quizMacroManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, QuizPageManager quizPageManager, QuizMediaInserter quizMediaInserter, LabelManager labelManager, ConfluencePermissionHelper confluencePermissionHelper, QuizQuestionMapService quizQuestionMapService, UpdateMacroManager updateMacroManager, QuestionCategoryService categoryService, QuestionStatsHelper statsHelper, SoyTemplateRenderer soyTemplateRenderer) {
        this.pageManager = pageManager;
        this.quizMacroManager = quizMacroManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.quizPageManager = quizPageManager;
        this.quizMediaInserter = quizMediaInserter;
        this.labelManager = labelManager;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.quizQuestionMapService = quizQuestionMapService;
        this.updateMacroManager = updateMacroManager;
        this.categoryService = categoryService;
        this.statsHelper = statsHelper;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @GET
    @Path(value="parent-page")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getMails(@QueryParam(value="pageId") Long pageId) throws Exception {
        Page parent = this.pageManager.getPage(pageId.longValue()).getParent();
        if (parent == null) {
            return Response.ok().build();
        }
        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)parent);
        return Response.ok((Object)new ParentPage(parent.getId(), params.isEmpty())).build();
    }

    @POST
    @Path(value="create")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response create(@FormParam(value="pageId") Long pageId, @FormParam(value="text") String text, @FormParam(value="extension") String extension, @FormParam(value="type") Integer type, @FormParam(value="answers") List<String> answers, @FormParam(value="quizIds") List<Long> quizIds, @FormParam(value="correct") String correct, @FormParam(value="random") String random, @FormParam(value="correctFeedback") String correctFeedback, @FormParam(value="wrongFeedback") String wrongFeedback, @FormParam(value="categoryId") Integer categoryId) {
        Page parent = this.pageManager.getPage(pageId.longValue());
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)parent.toPageContext());
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.confluencePermissionHelper.canEdit((ContentEntityObject)parent) || !this.confluencePermissionHelper.canCreatePage(parent.getSpace())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ArrayList<String> answersWithMedia = new ArrayList<String>();
        for (String answer : answers) {
            answersWithMedia.add(this.quizMediaInserter.createMediaMacros(answer, (ConversionContext)context));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", this.getQuestionType(type));
        params.put("answers", answersWithMedia);
        params.put("correct", correct);
        params.put("random", random);
        params.put("correctFeedbackWithHtml", correctFeedback.isEmpty() ? "&nbsp;" : this.quizMediaInserter.createMediaMacros(correctFeedback, (ConversionContext)context));
        params.put("wrongFeedbackWithHtml", wrongFeedback.isEmpty() ? "&nbsp;" : this.quizMediaInserter.createMediaMacros(wrongFeedback, (ConversionContext)context));
        params.put("i18n", this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)user)));
        params.put("extensionWithHtml", this.quizMediaInserter.createMediaMacros(extension, (ConversionContext)context));
        String body = VelocityUtils.getRenderedTemplate((String)"/vm/quiz/question/question.vm", params);
        Page page = this.quizPageManager.createPage(parent, user, text.replaceAll("\n", " "), body);
        LabelUtil.addLabel((String)"question", (LabelManager)this.labelManager, (Labelable)page);
        if (quizIds != null) {
            for (Long quizId : quizIds) {
                this.quizQuestionMapService.add(quizId, page.getId(), this.categoryService.getDefaultCategory(quizId, categoryId));
            }
        }
        return Response.ok((Object)page.getId()).build();
    }

    @POST
    @Path(value="change-answers")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateAnswers(@FormParam(value="pageId") Long pageId, @FormParam(value="value") String value) throws Exception {
        if (!this.confluencePermissionHelper.canEdit(pageId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("answers", value);
        this.updateMacroManager.updateParams(pageId, "quiz-answers", params);
        return Response.ok().build();
    }

    @POST
    @Path(value="change-answers-randomize")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateAnswersRandomize(@FormParam(value="pageIds") List<Long> pageIds, @FormParam(value="values") List<String> values) throws Exception {
        for (int i = 0; i < pageIds.size(); ++i) {
            if (!this.confluencePermissionHelper.canEdit(pageIds.get(i))) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("random", values.get(i));
            this.updateMacroManager.updateParams(pageIds.get(i), "quiz-answers", params);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="remove-question")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeQuestion(@FormParam(value="pageIds") List<Long> pageIds, @FormParam(value="quizIds") List<Long> quizIds) {
        for (Long quizId : quizIds) {
            if (!this.confluencePermissionHelper.canEdit(quizId)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            for (Long pageId : pageIds) {
                this.quizQuestionMapService.remove(quizId, pageId);
            }
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="add-questions")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addQuestion(@FormParam(value="questionIds") List<Long> questionIds, @FormParam(value="quizIds") List<Long> quizIds, @FormParam(value="categoryId") Integer categoryId) {
        for (Long quizId : quizIds) {
            if (!this.confluencePermissionHelper.canEdit(quizId)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            QuestionCategory category = this.categoryService.getDefaultCategory(quizId, categoryId);
            for (Long questionId : questionIds) {
                this.quizQuestionMapService.add(quizId, questionId, category);
            }
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="question/reorder")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response reorderModules(@FormParam(value="quizId") Long quizId, @FormParam(value="ids") List<Long> ids, @FormParam(value="id") Long id, @FormParam(value="categoryId") Integer categoryId) {
        if (!this.confluencePermissionHelper.canEdit(quizId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.quizQuestionMapService.reorder(quizId, ids);
        this.quizQuestionMapService.setCategory(quizId, id, categoryId);
        return Response.ok().build();
    }

    @POST
    @Path(value="category/add")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addCategory(@FormParam(value="name") String name, @FormParam(value="quizId") Long quizId) {
        if (!this.confluencePermissionHelper.canEdit(quizId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)this.categoryService.create(quizId, name).getID()).build();
    }

    @POST
    @Path(value="category/rename")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response renameCategory(@FormParam(value="name") String name, @FormParam(value="id") Integer id, @FormParam(value="quizId") Long quizId) {
        if (!this.confluencePermissionHelper.canEdit(quizId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.categoryService.rename(quizId, id, name);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="category/delete")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response renameCategory(@FormParam(value="ids") List<Integer> ids, @FormParam(value="quizId") Long quizId) {
        if (!this.confluencePermissionHelper.canEdit(quizId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)this.categoryService.remove(quizId, ids)).build();
    }

    @POST
    @Path(value="category/reorder")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response reorderCategory(@FormParam(value="quizId") Long quizId, @FormParam(value="ids") List<Integer> ids) {
        if (!this.confluencePermissionHelper.canEdit(quizId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.categoryService.reorder(quizId, ids);
        return Response.ok().build();
    }

    @GET
    @Path(value="categories/report")
    @XsrfProtectionExcluded
    @Produces(value={"text/html"})
    public Response getCategoriesReport(@QueryParam(value="quizId") Long quizId) throws MacroExecutionException {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (!this.confluencePermissionHelper.canView((ContentEntityObject)page)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        QuestionsStats data = this.statsHelper.getStats((ContentEntityObject)page, false, page.getSpaceKey());
        Map velocityContext = MacroUtils.defaultVelocityContext();
        velocityContext.put("soyRenderer", this.soyTemplateRenderer);
        velocityContext.put("categoriesStats", data.getStats());
        String html = VelocityUtils.getRenderedTemplate((String)"/vm/quiz/report/category-report.vm", (Map)velocityContext);
        return Response.ok((Object)html).build();
    }

    @GET
    @Path(value="questions/report")
    @XsrfProtectionExcluded
    @Produces(value={"text/html"})
    public Response getQuestionsReport(@QueryParam(value="quizId") Long quizId) throws MacroExecutionException {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (!this.confluencePermissionHelper.canView((ContentEntityObject)page)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        QuestionsStats data = this.statsHelper.getStats((ContentEntityObject)page, false, page.getSpaceKey());
        Map velocityContext = MacroUtils.defaultVelocityContext();
        velocityContext.put("questionsStats", data.getQuestions());
        String html = VelocityUtils.getRenderedTemplate((String)"/vm/quiz/report/questions-report.vm", (Map)velocityContext);
        return Response.ok((Object)html).build();
    }

    @GET
    @Path(value="macro")
    @XsrfProtectionExcluded
    @Produces(value={"text/html"})
    public Response getMacro(@QueryParam(value="quizId") Long quizId) throws XhtmlException {
        Page page = this.pageManager.getPage(quizId.longValue());
        if (!this.confluencePermissionHelper.canView((ContentEntityObject)page)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)this.quizMacroManager.renderQuestionsReportMacro((ContentEntityObject)page)).build();
    }

    private String getQuestionType(int type) {
        switch (type) {
            case 0: {
                return "Multiple choice";
            }
            case 3: {
                return "Free text";
            }
            case 4: {
                return "Free text (checked automatically)";
            }
        }
        return "Single choice";
    }
}

