/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.TrustedRequest;
import com.atlassian.sal.api.net.TrustedRequestFactory;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.cache.AttachmentsCacheManager;
import com.stiltsoft.confluence.quiz.entity.AttachmentParams;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="drawio")
@AnonymousAllowed
public class DrawIORest {
    private AttachmentsCacheManager cacheManager;
    protected UserEntityService userEntityService;
    private UserAccessor userAccessor;
    private SettingsManager settingsManager;
    private TrustedRequestFactory trustedRequestFactory;

    public DrawIORest(AttachmentsCacheManager cacheManager, UserEntityService userEntityService, UserAccessor userAccessor, SettingsManager settingsManager, TrustedRequestFactory trustedRequestFactory) {
        this.cacheManager = cacheManager;
        this.userEntityService = userEntityService;
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
        this.trustedRequestFactory = trustedRequestFactory;
    }

    @GET
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response checkQuizzes(@QueryParam(value="apd") String apd) throws Exception {
        AttachmentParams params = QuizEncrypter.decryptAttachmentParams(apd);
        if ((long)params.getUserId().intValue() - this.cacheManager.get(params) != 0L) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.cacheManager.remove(params);
        String url = "/rest/drawio/1.0/diagram/crud/" + params.getUrlParam();
        String authorKey = this.userEntityService.getUser(params.getAuthorId()).getKey();
        ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(authorKey));
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (baseUrl.startsWith("http://docker.stiltsoft.com:")) {
            baseUrl = "http://localhost:8090";
        }
        TrustedRequest trustedRequest = this.trustedRequestFactory.createTrustedRequest(Request.MethodType.GET, baseUrl + url);
        trustedRequest.addTrustedTokenAuthentication(new URI(baseUrl).getHost(), author.getName());
        String response = trustedRequest.execute();
        return Response.ok((Object)response).build();
    }
}

