/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseAnswers;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSectionService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.course.DefaultCourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizQuestionMapService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.ReminderService;
import com.stiltsoft.confluence.quiz.entity.DueDateChanges;
import com.stiltsoft.confluence.quiz.entity.EnrollResult;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.SearchResult;
import com.stiltsoft.confluence.quiz.entity.SingleValueResponse;
import com.stiltsoft.confluence.quiz.entity.UserRestEntity;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.course.CourseImage;
import com.stiltsoft.confluence.quiz.entity.course.CourseParticipantStats;
import com.stiltsoft.confluence.quiz.entity.course.CourseSelfEnrollmentType;
import com.stiltsoft.confluence.quiz.entity.course.Module;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.mail.MailSender;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.CourseLearningAccessibilityHelper;
import com.stiltsoft.confluence.quiz.manager.CourseReportHelper;
import com.stiltsoft.confluence.quiz.manager.LicenseManager;
import com.stiltsoft.confluence.quiz.manager.ParticipantsHelper;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import com.stiltsoft.confluence.quiz.workbox.WorkboxManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="course")
@AnonymousAllowed
public class CourseRest {
    private static final Logger log = LoggerFactory.getLogger(CourseRest.class);
    private static final int STATS_MAX_LIMIT = 200;
    private CourseSettingsService settingsService;
    private CourseSectionService sectionService;
    private CourseModuleService moduleService;
    private CQPermissionHelper cqPermissionHelper;
    private ConfluencePermissionHelper confluencePermissionHelper;
    private PageManager pageManager;
    private LicenseManager licenseManager;
    private ParticipantsHelper participantsHelper;
    private CourseStateEntityService courseStateEntityService;
    private MailSender mailSender;
    private WorkboxManager workboxManager;
    private UserEntityService userEntityService;
    private QuizQuestionMapService quizQuestionMapService;
    private QuizMacroManager quizMacroManager;
    private TransactionTemplate transactionTemplate;
    private DueDateHelper dueDateHelper;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private CourseLearningAccessibilityHelper courseLearningAccessibilityHelper;
    private final UserAccessor userAccessor;
    private ReminderService reminderService;
    private CourseReportHelper courseReportHelper;

    public CourseRest(CourseSettingsService settingsService, CourseSectionService sectionService, CourseModuleService moduleService, CQPermissionHelper cqPermissionHelper, ConfluencePermissionHelper confluencePermissionHelper, PageManager pageManager, LicenseManager licenseManager, ParticipantsHelper participantsHelper, CourseStateEntityService courseStateEntityService, MailSender mailSender, WorkboxManager workboxManager, UserEntityService userEntityService, QuizQuestionMapService quizQuestionMapService, QuizMacroManager quizMacroManager, TransactionTemplate transactionTemplate, DueDateHelper dueDateHelper, ConfluenceContentSearcher confluenceContentSearcher, CourseLearningAccessibilityHelper courseLearningAccessibilityHelper, UserAccessor userAccessor, ReminderService reminderService, CourseReportHelper courseReportHelper) {
        this.settingsService = settingsService;
        this.sectionService = sectionService;
        this.moduleService = moduleService;
        this.cqPermissionHelper = cqPermissionHelper;
        this.confluencePermissionHelper = confluencePermissionHelper;
        this.pageManager = pageManager;
        this.licenseManager = licenseManager;
        this.participantsHelper = participantsHelper;
        this.courseStateEntityService = courseStateEntityService;
        this.mailSender = mailSender;
        this.workboxManager = workboxManager;
        this.userEntityService = userEntityService;
        this.quizQuestionMapService = quizQuestionMapService;
        this.quizMacroManager = quizMacroManager;
        this.transactionTemplate = transactionTemplate;
        this.dueDateHelper = dueDateHelper;
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.courseLearningAccessibilityHelper = courseLearningAccessibilityHelper;
        this.userAccessor = userAccessor;
        this.reminderService = reminderService;
        this.courseReportHelper = courseReportHelper;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="expand")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setExpanded(@FormParam(value="courseId") Long courseId, @FormParam(value="expanded") Boolean expanded) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.setExpanded(courseId, expanded);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="section/add")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addSection(@FormParam(value="courseId") Long courseId) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            return Response.ok((Object)this.sectionService.addSectionTx(courseId, "")).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="section/rename")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response renameSection(@FormParam(value="courseId") Long courseId, @FormParam(value="name") String name, @FormParam(value="id") Integer id) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.sectionService.rename(courseId, id, name);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="section/remove")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeSection(@FormParam(value="courseId") Long courseId, @FormParam(value="id") Integer id) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.sectionService.removeTx(courseId, id);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="section/reorder")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response reorderSections(@FormParam(value="courseId") Long courseId, @FormParam(value="ids") List<Integer> ids) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.sectionService.reorder(courseId, ids);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="module/add")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addModule(@FormParam(value="courseId") Long courseId, @FormParam(value="pageId") Long pageId, @FormParam(value="type") Integer type, @FormParam(value="sectionId") Integer sectionId) throws XhtmlException {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            Integer id = this.moduleService.addTx(courseId, pageId, type, sectionId);
            Module module = new Module(id);
            if (type.equals(DefaultCourseModuleService.QUIZ_MODULE)) {
                module.setEmptyQuiz(this.quizQuestionMapService.getQuestionsCount(pageId) == 0);
                if (!module.getEmptyQuiz().booleanValue()) {
                    QuizParams quizParams = this.quizMacroManager.getQuizParams((ContentEntityObject)this.pageManager.getPage(pageId.longValue()));
                    module.setQuizAttempts(quizParams.getAttempts());
                }
            }
            return Response.ok((Object)module).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="module/remove")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeModule(@FormParam(value="courseId") Long courseId, @FormParam(value="id") Integer id) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.moduleService.removeTx(courseId, id);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="module/reorder")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response reorderModules(@FormParam(value="courseId") Long courseId, @FormParam(value="ids") List<Integer> ids, @FormParam(value="id") Integer id, @FormParam(value="sectionId") Integer sectionId) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.moduleService.reorder(courseId, ids);
            this.moduleService.setSection(courseId, id, sectionId);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="bulk/remove")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeBulk(@FormParam(value="courseId") Long courseId, @FormParam(value="sectionIds") List<Integer> sectionIds, @FormParam(value="moduleIds") List<Integer> moduleIds) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            for (Integer id : moduleIds) {
                this.moduleService.removeTx(courseId, id);
            }
            for (Integer id : sectionIds) {
                this.sectionService.removeTx(courseId, id);
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/desc")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setDescription(@FormParam(value="courseId") Long courseId, @FormParam(value="value") String desc) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.setDesc(courseId, desc);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/order")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setOrder(@FormParam(value="courseId") Long courseId, @FormParam(value="value") Integer order) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.setOrder(courseId, order);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/reminder-desc")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setReminderDescription(@FormParam(value="courseId") Long courseId, @FormParam(value="value") String desc) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.setReminderDesc(courseId, desc);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/reminder-days")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setReminderDays(@FormParam(value="courseId") Long courseId, @FormParam(value="value") Integer daysAfterEnrollment, @FormParam(value="updateEnrolled") Boolean updateEnrolled) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.setReminderDays(courseId, daysAfterEnrollment);
            if (Boolean.TRUE.equals(updateEnrolled)) {
                this.reminderService.updateCourseDAEReminders(courseId, daysAfterEnrollment);
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/self-enrollment-type")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setSelfEnrollment(@FormParam(value="courseId") Long courseId, @FormParam(value="type") Integer type, @FormParam(value="groups") String groups) {
        if (this.confluencePermissionHelper.canEdit(courseId) && (!CourseSelfEnrollmentType.SPECIFIC_GROUPS.equals(type) || groups.length() != 0)) {
            this.settingsService.setSelfEnrollmentType(courseId, type);
            this.settingsService.setSelfEnrollmentGroups(courseId, CourseSelfEnrollmentType.SPECIFIC_GROUPS.equals(type) ? groups : null);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/category/add")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addCategory(@FormParam(value="courseId") Long courseId, @FormParam(value="category") Integer category) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.addCategory(courseId, category);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/category/delete")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response deleteCategory(@FormParam(value="courseId") Long courseId, @FormParam(value="category") Integer category) {
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.deleteCategory(courseId, category);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/image")
    @XsrfProtectionExcluded
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setImage(CourseImage courseImage) {
        AbstractPage page = this.pageManager.getAbstractPage(courseImage.getCourseId().longValue());
        if (this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            return Response.ok((Object)("\"" + this.settingsService.setImage(page, courseImage) + "\"")).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/due-date")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setDueDate(@FormParam(value="courseId") Long courseId, @FormParam(value="value") String dueDate, @FormParam(value="updateEnrolled") Boolean updateEnrolled) {
        Page page = this.pageManager.getPage(courseId.longValue());
        if (this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
            this.settingsService.setDueDate(courseId, dueDate);
            if (Boolean.TRUE.equals(updateEnrolled)) {
                this.sendCourseDueDateUpdatedNotification(this.courseStateEntityService.updateDueDateAndGetUpdated(courseId, StringUtils.defaultString((String)dueDate), ""), page);
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="settings/due-days")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response setDueDays(@FormParam(value="courseId") Long courseId, @FormParam(value="value") String dueDays, @FormParam(value="updateEnrolled") Boolean updateEnrolled) {
        Page page = this.pageManager.getPage(courseId.longValue());
        if (this.confluencePermissionHelper.canEdit(courseId)) {
            this.settingsService.setDueDays(courseId, dueDays);
            if (Boolean.TRUE.equals(updateEnrolled)) {
                this.sendCourseDueDateUpdatedNotification(this.courseStateEntityService.updateDueDateAndGetUpdated(courseId, "", StringUtils.defaultString((String)dueDays)), page);
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="check-empty-quiz")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response findQuizWithoutQuestionsInCourse(@QueryParam(value="courseId") Long courseId) {
        if (this.confluencePermissionHelper.canView(courseId)) {
            for (CourseModule module : this.moduleService.getQuizModules(courseId)) {
                AbstractPage page;
                if (this.quizQuestionMapService.getQuestions(module.getModuleId()).length != 0 || (page = this.pageManager.getAbstractPage(module.getModuleId().longValue())) == null || page.isDeleted()) continue;
                return Response.ok((Object)new SearchResult(module.getModuleId(), page.getDisplayTitle())).build();
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="enroll")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response enroll(final @FormParam(value="courseId") Long courseId, final @FormParam(value="desc") String desc, @FormParam(value="users") List<String> users, @FormParam(value="groups") List<String> groups, @FormParam(value="emails") List<String> emails) throws Exception {
        AbstractPage coursePage = this.pageManager.getAbstractPage(courseId.longValue());
        if (coursePage == null || coursePage.isDeleted() || !this.confluencePermissionHelper.canEdit((ContentEntityObject)coursePage) || !this.licenseManager.isActive()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Set<ConfluenceUser> participants = this.participantsHelper.getParticipants(users, groups, emails);
        Set<Integer> alreadyEnrolledUserIds = this.courseStateEntityService.getActualEnrolledUserIds(courseId);
        final ArrayList<ConfluenceUser> usersToEnroll = new ArrayList<ConfluenceUser>();
        ArrayList<UserRestEntity> alreadyEnrolledUsers = new ArrayList<UserRestEntity>();
        for (ConfluenceUser participant : participants) {
            int userId = this.userEntityService.getUserId(participant.getKey().getStringValue());
            if (alreadyEnrolledUserIds.contains(userId)) {
                UserRestEntity userRestEntity = this.getUserRestEntity(participant);
                alreadyEnrolledUsers.add(userRestEntity);
                continue;
            }
            usersToEnroll.add(participant);
        }
        final ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        final int authorId = this.userEntityService.getUserId(author.getKey().getStringValue());
        final List<CourseStateEntity> enrolls = this.courseStateEntityService.enroll(courseId, usersToEnroll, author.getKey().getStringValue());
        new Thread(new Runnable(){

            @Override
            public void run() {
                CourseRest.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() {
                        AbstractPage page = CourseRest.this.pageManager.getAbstractPage(courseId.longValue());
                        for (int i = 0; i < enrolls.size(); ++i) {
                            try {
                                ConfluenceUser participant = (ConfluenceUser)usersToEnroll.get(i);
                                CourseStateEntity enroll = (CourseStateEntity)enrolls.get(i);
                                int rid = enroll.getID();
                                String formattedDueDate = CourseRest.this.dueDateHelper.formatDueDate(enroll.getDueDate(), (ConfluenceUser)(participant.getName() != null ? participant : null));
                                CourseRest.this.mailSender.sendCourse(participant.getEmail(), participant.getKey().getStringValue(), page, enroll.getUserId(), author, authorId, desc, rid, formattedDueDate);
                                if (participant.getName() == null) continue;
                                CourseRest.this.workboxManager.addCourseNotification(participant, author, page, enroll.getUserId(), authorId, rid, desc);
                                continue;
                            }
                            catch (Exception e) {
                                log.error("Failed to notify users on course enrollment", (Throwable)e);
                            }
                        }
                        return null;
                    }
                });
            }
        }).start();
        return Response.ok(new EnrollResult(usersToEnroll.size(), alreadyEnrolledUsers)).build();
    }

    @GET
    @Path(value="self-enroll")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response selfEnroll(@QueryParam(value="courseId") Long courseId) throws Exception {
        String mail;
        String userKey;
        ConfluenceUser participant = AuthenticatedUserThreadLocal.get();
        AbstractPage page = this.pageManager.getAbstractPage(courseId.longValue());
        Optional<CourseSettings> courseSettingsOpt = this.settingsService.get(courseId);
        if (!(this.licenseManager.isActive() && page != null && courseSettingsOpt.isPresent() && this.courseLearningAccessibilityHelper.isAvailableForCurrentUser(courseSettingsOpt.get()))) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (participant == null) {
            userKey = "Participant " + (this.userEntityService.getUsersCount() + 1);
            mail = null;
        } else {
            userKey = participant.getKey().getStringValue();
            mail = participant.getEmail();
        }
        CourseStateEntity[] entities = this.courseStateEntityService.getActualStates(courseId, userKey);
        if (entities.length == 0) {
            ConfluenceUser author = this.confluencePermissionHelper.getAnyUserWhoCanViewPage(page);
            if (author == null) {
                author = participant;
            }
            int userId = this.userEntityService.getUserId(userKey);
            int authorId = this.userEntityService.getUserId(author.getKey().getStringValue());
            int rid = this.courseStateEntityService.enroll(courseId, userKey, mail, author.getKey().getStringValue(), participant);
            return Response.ok((Object)("{\"url\": \"/quiz/course/view.action?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(courseId, userId, authorId, userKey, rid))) + "\"}")).build();
        }
        return Response.ok((Object)("{\"url\": \"/quiz/course/view.action?qsd=" + GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(courseId, entities[0].getUserId(), entities[0].getAuthor(), userKey, entities[0].getID()))) + "\"}")).build();
    }

    @POST
    @Path(value="submit")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response submit(@FormParam(value="param") String param, @FormParam(value="pid") Long pid, @FormParam(value="attempt") Long attempt) throws Exception {
        MailParams params = this.getParams(param);
        if (this.cqPermissionHelper.isUserAuthorized(params)) {
            Optional<CourseEnrollWrapper> wrapperOpt = this.courseStateEntityService.getCourseEnrollWrapper(params.getUid(), params.getQid(), params.getRid());
            if (!wrapperOpt.isPresent()) {
                return Response.ok((Object)new SingleValueResponse("ENROLL_NOT_FOUND")).build();
            }
            CourseEnrollWrapper courseEnrollWrapper = wrapperOpt.get();
            if (courseEnrollWrapper.getStatus() == 4) {
                return Response.ok((Object)new SingleValueResponse("OVERDUE")).build();
            }
            Optional<CourseAnswers> courseAnswersOpt = this.courseStateEntityService.saveAnswer(params.getUid(), params.getQid(), params.getAid(), pid, attempt, courseEnrollWrapper);
            if (courseAnswersOpt.isPresent()) {
                return Response.ok((Object)new SingleValueResponse("MODULE_ANSWERED")).build();
            }
            return Response.ok((Object)new SingleValueResponse("MODULE_NOT_ANSWERED")).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="answers/remove")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeAnswers(@FormParam(value="courseId") Long courseId, @FormParam(value="ids") List<Integer> ids) {
        if (courseId != null) {
            Page page = this.pageManager.getPage(courseId.longValue());
            if (page == null || page.isDeleted() || !this.confluencePermissionHelper.canEdit((ContentEntityObject)page)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.courseStateEntityService.delete(courseId, ids);
        } else {
            this.courseStateEntityService.deleteByUser(AuthenticatedUserThreadLocal.get().getKey().getStringValue(), ids);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="search")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response searchCourses(@QueryParam(value="title") String title) {
        List<AbstractPage> pages = this.confluenceContentSearcher.findCourses(title, 10);
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (AbstractPage page : pages) {
            results.add(new SearchResult(page.getId(), page.getDisplayTitle()));
        }
        return Response.ok(results).build();
    }

    @GET
    @Path(value="can-edit-courses")
    @XsrfProtectionExcluded
    @Produces(value={"text/plain"})
    public Response canEditCourses(@QueryParam(value="ids") List<Long> ids, @QueryParam(value="author") String authorKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (ids == null || ids.isEmpty()) {
            ids = new ArrayList<Long>();
            ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(authorKey));
            AuthenticatedUserThreadLocal.set((ConfluenceUser)author);
            for (Searchable searchable : this.confluenceContentSearcher.findCourses("", 1000)) {
                ids.add(searchable.getId());
            }
            AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        }
        boolean canEdit = ids.stream().allMatch(this.confluencePermissionHelper::canView);
        return Response.ok((Object)Boolean.toString(canEdit)).build();
    }

    @POST
    @Path(value="total-participant-stats")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getTotalParticipantStats(@FormParam(value="courseIds") List<Long> courseIds, @FormParam(value="studentIds") List<Integer> studentIds) {
        if (courseIds == null || studentIds == null) {
            return Response.ok((Object)0).build();
        }
        List<Long> allowedCourseIds = courseIds.stream().filter(this.confluencePermissionHelper::canView).collect(Collectors.toList());
        int total = this.courseStateEntityService.countStates(allowedCourseIds, studentIds);
        return Response.ok((Object)total).build();
    }

    @GET
    @Path(value="participant-stats")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response findParticipantStats(@QueryParam(value="courseIds") List<Long> courseIds, @QueryParam(value="studentIds") List<Integer> studentIds, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        if (courseIds == null || studentIds == null) {
            return Response.ok(Collections.emptyList()).build();
        }
        int validatedLimit = limit == null || limit > 200 ? 200 : limit;
        int validatedStart = start == null ? 0 : start;
        List<Long> allowedCourseIds = courseIds.stream().filter(this.confluencePermissionHelper::canView).collect(Collectors.toList());
        List<CourseParticipantStats> participantStats = this.courseReportHelper.getParticipantStats(allowedCourseIds, studentIds, validatedStart, validatedLimit);
        return Response.ok(participantStats).build();
    }

    private MailParams getParams(String param) throws Exception {
        return QuizEncrypter.decrypt(GeneralUtil.urlDecode((String)param));
    }

    private void sendCourseDueDateUpdatedNotification(Map<CourseEnrollWrapper, DueDateChanges> map, Page page) {
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        for (Map.Entry<CourseEnrollWrapper, DueDateChanges> updatedEntity : map.entrySet()) {
            try {
                this.mailSender.sendCourseDueDateUpdated(updatedEntity.getKey(), page, author, updatedEntity.getValue());
            }
            catch (Exception e) {
                log.error("Failed to send course notification", (Throwable)e);
            }
        }
    }

    private UserRestEntity getUserRestEntity(ConfluenceUser participant) {
        if (participant.getName() != null) {
            return new UserRestEntity(participant.getKey().getStringValue(), participant.getName(), participant.getFullName(), "");
        }
        return new UserRestEntity(participant.getKey().getStringValue(), participant.getKey().getStringValue(), participant.getKey().getStringValue(), "email");
    }
}

