/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseCategory;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseCategoryService;
import com.stiltsoft.confluence.quiz.entity.PageRestEntity;
import com.stiltsoft.confluence.quiz.manager.CQPermissionHelper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="categories")
public class CategoriesRest {
    private CQPermissionHelper permissionHelper;
    private CourseCategoryService categoryService;
    private PageManager pageManager;

    public CategoriesRest(CQPermissionHelper permissionHelper, CourseCategoryService categoryService, PageManager pageManager) {
        this.permissionHelper = permissionHelper;
        this.categoryService = categoryService;
        this.pageManager = pageManager;
    }

    @POST
    @Path(value="add-category")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response addCategory(@FormParam(value="name") String name) {
        if (!this.permissionHelper.isLearningAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)this.categoryService.create(name)).build();
    }

    @POST
    @Path(value="update-category")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateCategory(@FormParam(value="id") Integer id, @FormParam(value="name") String name) {
        if (!this.permissionHelper.isLearningAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.categoryService.rename(id, name);
        return Response.ok().build();
    }

    @POST
    @Path(value="delete-category")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response deleteCategory(@FormParam(value="id") Integer id) {
        if (!this.permissionHelper.isLearningAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.categoryService.delete(id);
        return Response.ok().build();
    }

    @POST
    @Path(value="reorder")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response reorder(@FormParam(value="ids") List<Integer> ids) {
        if (!this.permissionHelper.isLearningAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.categoryService.reorder(ids);
        return Response.ok().build();
    }

    @GET
    @Path(value="usage-category")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response usageCategory(@QueryParam(value="id") Integer id) {
        if (!this.permissionHelper.isLearningAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ArrayList<PageRestEntity> courses = new ArrayList<PageRestEntity>();
        CourseCategory[] categories = this.categoryService.getCategories(id);
        if (categories.length == 1) {
            for (CourseSettings course : categories[0].getCourseSettings()) {
                AbstractPage page = this.pageManager.getAbstractPage(course.getCourseId().longValue());
                if (page == null || page.isDeleted()) continue;
                courses.add(new PageRestEntity(page.getId(), page.getTitle()));
            }
        }
        return Response.ok(courses).build();
    }
}

