/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.service.UserEntityDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserEntityService {
    private UserEntityDao dao;
    private Map<String, Integer> usersCache;
    private Map<Integer, UserEntity> userEntityMap;

    public UserEntityService(UserEntityDao dao) {
        this.dao = dao;
        this.usersCache = new HashMap<String, Integer>();
        this.userEntityMap = new HashMap<Integer, UserEntity>();
    }

    public int getUserId(String key) {
        if (this.usersCache.containsKey(key)) {
            return this.usersCache.get(key);
        }
        return this.getUserId(key, null);
    }

    public int getUserId(String key, String name) {
        if (this.usersCache.containsKey(key) && (name == null || name.equals(this.userEntityMap.get(this.usersCache.get(key)).getName()))) {
            return this.usersCache.get(key);
        }
        UserEntity entity = this.dao.getUserEntity(key, name);
        this.userEntityMap.put(entity.getID(), entity);
        this.usersCache.put(key, entity.getID());
        return entity.getID();
    }

    public UserEntity getUser(int id) {
        if (!this.userEntityMap.containsKey(id)) {
            UserEntity userEntity = this.dao.getUser(id);
            this.userEntityMap.put(id, userEntity);
            this.usersCache.put(userEntity.getKey(), userEntity.getID());
        }
        return this.userEntityMap.get(id);
    }

    public int getUsersCount() {
        return this.dao.getUsersCount();
    }

    public List<String> getEmails(String part, int limit) {
        return this.dao.getEmails(part, limit);
    }
}

