/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.Modification;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.stiltsoft.confluence.quiz.manager.QuizServicePageManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMacroManager {
    private static final Logger log = LoggerFactory.getLogger(UpdateMacroManager.class);
    private PageManager pageManager;
    private XhtmlContent xhtmlContent;
    private QuizServicePageManager quizServicePageManager;
    private TransactionTemplate transactionTemplate;

    public UpdateMacroManager(PageManager pageManager, XhtmlContent xhtmlContent, QuizServicePageManager quizServicePageManager, TransactionTemplate transactionTemplate) {
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
        this.quizServicePageManager = quizServicePageManager;
        this.transactionTemplate = transactionTemplate;
    }

    public void updateParams(Long pageId, final String name, final Map<String, String> params) {
        this.transactionTemplate.execute(() -> {
            AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
            this.pageManager.saveNewVersion((ContentEntityObject)page, (Modification)new Modification<AbstractPage>(){

                public void modify(AbstractPage content) {
                    try {
                        DefaultConversionContext context = new DefaultConversionContext((RenderContext)content.toPageContext());
                        content.setBodyAsString(UpdateMacroManager.this.xhtmlContent.replaceMacroDefinitionsWithString(content.getBodyAsString(), (ConversionContext)context, (MacroDefinitionReplacer)new MacroParamsReplacer((ConversionContext)context, name, params)));
                    }
                    catch (XhtmlException e) {
                        log.error("Failed to update quiz settings", (Throwable)e);
                    }
                }
            }, (SaveContext)new DefaultSaveContext(true, true, false));
            return null;
        });
    }

    public void updateQuizPageParams(BlueprintPageCreateEvent event, Map<String, String> additionalQuizParams) {
        this.transactionTemplate.execute(() -> {
            AbstractPage page = this.pageManager.getAbstractPage(event.getPage().getId());
            this.pageManager.saveNewVersion((ContentEntityObject)page, content -> {
                try {
                    DefaultConversionContext context = new DefaultConversionContext((RenderContext)content.toPageContext());
                    String pageBody = this.updateQuizSettingsMacroParams(page.getBodyAsString(), (ConversionContext)context, additionalQuizParams);
                    pageBody = this.updateQuizAnswersReportMacroParams(pageBody, (ConversionContext)context, page.getIdAsString());
                    content.setBodyAsString(pageBody);
                }
                catch (XhtmlException e) {
                    log.error("Failed to update quiz settings", (Throwable)e);
                }
            }, (SaveContext)new DefaultSaveContext(true, true, false));
            return null;
        });
    }

    private String updateQuizSettingsMacroParams(String pageBody, ConversionContext context, Map<String, String> params) throws XhtmlException {
        return this.updateMacroParams("quiz-settings", pageBody, context, params);
    }

    private String updateQuizAnswersReportMacroParams(String pageBody, ConversionContext context, String quizzesIds) throws XhtmlException {
        HashMap<String, String> additionalQuizAnswerReportParams = new HashMap<String, String>();
        additionalQuizAnswerReportParams.put("quizzes", quizzesIds);
        return this.updateMacroParams("quiz-answers-report", pageBody, context, additionalQuizAnswerReportParams);
    }

    private String updateMacroParams(String macroName, String pageBody, ConversionContext context, Map<String, String> params) throws XhtmlException {
        return this.xhtmlContent.replaceMacroDefinitionsWithString(pageBody, context, (MacroDefinitionReplacer)new MacroParamsReplacer(context, macroName, params));
    }

    private class MacroParamsReplacer
    implements MacroDefinitionReplacer {
        protected ConversionContext context;
        private String name;
        private Map<String, String> params;

        public MacroParamsReplacer(ConversionContext context, String name, Map<String, String> params) {
            this.context = context;
            this.name = name;
            this.params = params;
        }

        public String replace(MacroDefinition macroDefinition) throws XhtmlException {
            if (this.name.equals(macroDefinition.getName())) {
                for (Map.Entry<String, String> param : this.params.entrySet()) {
                    macroDefinition.setParameter(param.getKey(), param.getValue());
                    macroDefinition.setTypedParameter(param.getKey(), (Object)param.getValue());
                }
            }
            return UpdateMacroManager.this.xhtmlContent.convertMacroDefinitionToStorage(macroDefinition, this.context);
        }
    }
}

