/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.stiltsoft.confluence.quiz.ao.dao.ReminderDao;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizReminder;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.Answer;
import com.stiltsoft.confluence.quiz.mail.MailSender;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.QuizResultsHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderController {
    private static final Logger log = LoggerFactory.getLogger(ReminderController.class);
    private static final int LIMIT = 500;
    private ReminderDao reminderDao;
    private QuizService quizService;
    private CourseStateEntityService courseStateEntityService;
    private CourseSettingsService courseSettingsService;
    private QuizResultsHelper resultsHelper;
    private QuizMacroManager macroManager;
    private MailSender mailSender;
    private WikiStyleRenderer wikiStyleRenderer;
    private PageManager pageManager;

    public ReminderController(ReminderDao reminderDao, QuizService quizService, CourseStateEntityService courseStateEntityService, CourseSettingsService courseSettingsService, QuizMacroManager macroManager, MailSender mailSender, WikiStyleRenderer wikiStyleRenderer, QuizResultsHelper resultsHelper, PageManager pageManager) {
        this.reminderDao = reminderDao;
        this.quizService = quizService;
        this.courseStateEntityService = courseStateEntityService;
        this.courseSettingsService = courseSettingsService;
        this.macroManager = macroManager;
        this.mailSender = mailSender;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.resultsHelper = resultsHelper;
        this.pageManager = pageManager;
    }

    public void sendReminders(List<QuizStateEntity> entities, ConfluenceUser author, String message, Page page) {
        QuizResultsHelper.Answers answers = this.getAnswers(entities);
        String messageHtml = this.convertWiki(page, message);
        for (Answer answer : answers.getIncompleteAnswers()) {
            this.mailSender.sendRemind(answer, author, messageHtml, (AbstractPage)page);
        }
    }

    public void processQuizReminders() {
        List<QuizReminder> reminders;
        QuizReminderMessageCacheManager quizReminderMessageCacheManager = new QuizReminderMessageCacheManager();
        do {
            reminders = this.reminderDao.findQuizReminders(500);
            for (QuizReminder reminder : reminders) {
                List<QuizStateEntity> entities = this.quizService.findAttempts(reminder.getStateId());
                QuizResultsHelper.Answers answers = this.getAnswers(entities);
                for (Answer answer : answers.getIncompleteAnswers()) {
                    String message = quizReminderMessageCacheManager.get(answer, reminder.getType());
                    this.mailSender.sendRemind(answer, answer.getAuthor(), message, answer.getQuizPage());
                }
                this.reminderDao.remove(reminder);
            }
        } while (reminders.size() == 500);
    }

    public void processCourseReminders() {
        List<QuizReminder> reminders;
        CourseMailInfoCacheManager courseMailInfoCacheManager = new CourseMailInfoCacheManager();
        do {
            reminders = this.reminderDao.findCourseReminders(500);
            for (QuizReminder reminder : reminders) {
                CourseMailInfoCacheManager.CourseMailInfo courseMailInfo = courseMailInfoCacheManager.get(reminder.getQuizId());
                courseMailInfo.getPage().ifPresent(page -> this.courseStateEntityService.getUnfinishedState(reminder.getStateId()).ifPresent(entity -> {
                    try {
                        this.mailSender.sendCourseRemind((CourseStateEntity)entity, (AbstractPage)page, courseMailInfo.getText());
                    }
                    catch (Exception e) {
                        log.error("Failed to send course reminder", (Throwable)e);
                    }
                }));
                this.reminderDao.remove(reminder);
            }
        } while (reminders.size() == 500);
    }

    private String convertWiki(Page page, String text) {
        if (text == null) {
            return "";
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)page.toPageContext(), text);
    }

    private QuizResultsHelper.Answers getAnswers(List<QuizStateEntity> entities) {
        return this.resultsHelper.getAnswers(entities, true, true);
    }

    private class CourseMailInfoCacheManager {
        private final CourseMailInfo EMPTY_COURSE_MAIL_INFO = new CourseMailInfo(null, "");
        private Map<Long, CourseMailInfo> cache = new HashMap<Long, CourseMailInfo>();

        private CourseMailInfoCacheManager() {
        }

        private CourseMailInfo get(Long courseId) {
            if (!this.cache.containsKey(courseId)) {
                CourseMailInfo courseMailInfo;
                Page page = ReminderController.this.pageManager.getPage(courseId.longValue());
                if (page == null || page.isDeleted()) {
                    courseMailInfo = this.EMPTY_COURSE_MAIL_INFO;
                } else {
                    CourseSettings settings = ReminderController.this.courseSettingsService.getOrCreate(courseId);
                    String messageHtml = ReminderController.this.convertWiki(page, settings.getReminderDesc());
                    courseMailInfo = new CourseMailInfo((AbstractPage)page, messageHtml);
                }
                this.cache.put(courseId, courseMailInfo);
                return courseMailInfo;
            }
            return this.cache.get(courseId);
        }

        private class CourseMailInfo {
            private AbstractPage page;
            private String text;

            private CourseMailInfo(AbstractPage page, String text) {
                this.page = page;
                this.text = text;
            }

            private Optional<AbstractPage> getPage() {
                return Optional.ofNullable(this.page);
            }

            private String getText() {
                return this.text;
            }
        }
    }

    private class QuizReminderMessageCacheManager {
        private static final int ENROLLMENT_TYPE = 0;
        private static final int DUE_DATE_TYPE = 1;
        private Map<String, String> messageCache = new HashMap<String, String>();
        private Map<Long, QuizParams> quizParamsCache = new HashMap<Long, QuizParams>();

        private QuizReminderMessageCacheManager() {
        }

        private String get(Answer answer, Integer reminderType) {
            String key = this.getKey(answer, reminderType);
            if (!this.messageCache.containsKey(key)) {
                String message = this.getMessage(answer.getQuizId(), reminderType);
                this.messageCache.put(key, ReminderController.this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)answer.getQuizPage().toPageContext(), message));
            }
            return this.messageCache.get(key);
        }

        private String getKey(Answer answer, Integer reminderType) {
            return answer.getQuizId() + "_" + reminderType;
        }

        private String getMessage(Long quizId, Integer reminderType) {
            QuizParams quizParams = this.quizParamsCache.computeIfAbsent(quizId, key -> ReminderController.this.macroManager.getQuizParams((long)key));
            if (reminderType == 0) {
                return quizParams.getEnrollmentReminderMsg();
            }
            if (reminderType == 1) {
                return quizParams.getDueDateReminderMsg();
            }
            throw new RuntimeException("WRONG QUIZ REMINDER TYPE!");
        }
    }
}

