/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import java.util.HashMap;
import java.util.Map;

public class QuizServicePageManager {
    private static final String FEEDBACK_PAGE = "/vm/quiz/question/finish-feedback.vm";
    private static final String REVIEW_PAGE = "/vm/quiz/question/finish-feedback-review.vm";
    private static final String START_PAGE = "/vm/quiz/settings/start-page.vm";
    private static final String SUCCESS_PAGE_POSTFIX = " - Passed";
    private static final String FAIL_PAGE_POSTFIX = " - Failed";
    private static final String REVIEW_PAGE_POSTFIX = " - In Review";
    private static final String START_PAGE_POSTFIX = " - Start page";
    private static final String SUCCESS_PARAMETER = "success";
    private static final String INTERNALIZATION_PARAMETER = "i18n";
    private QuizPageManager quizPageManager;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;

    public QuizServicePageManager(QuizPageManager quizPageManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager) {
        this.quizPageManager = quizPageManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    public String createSuccessPageAndReturnId(BlueprintPageCreateEvent event) {
        Map<String, Object> params = this.getParams(event);
        params.put(SUCCESS_PARAMETER, true);
        return this.createPageAndReturnId(FEEDBACK_PAGE, params, event, SUCCESS_PAGE_POSTFIX);
    }

    public String createFailPageAndReturnId(BlueprintPageCreateEvent event) {
        Map<String, Object> params = this.getParams(event);
        params.put(SUCCESS_PARAMETER, false);
        return this.createPageAndReturnId(FEEDBACK_PAGE, params, event, FAIL_PAGE_POSTFIX);
    }

    public String createReviewPageAndReturnId(BlueprintPageCreateEvent event) {
        Map<String, Object> params = this.getParams(event);
        return this.createPageAndReturnId(REVIEW_PAGE, params, event, REVIEW_PAGE_POSTFIX);
    }

    public String createStartPageAndReturnId(BlueprintPageCreateEvent event) {
        Map<String, Object> params = this.getParams(event);
        return this.createPageAndReturnId(START_PAGE, params, event, START_PAGE_POSTFIX);
    }

    private Map<String, Object> getParams(BlueprintPageCreateEvent event) {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)event.getCreator()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(INTERNALIZATION_PARAMETER, i18NBean);
        return params;
    }

    private String createPageAndReturnId(String pathToTemplate, Map<String, Object> params, BlueprintPageCreateEvent event, String postfixForPage) {
        String body = VelocityUtils.getRenderedTemplate((String)pathToTemplate, params);
        Page parent = event.getPage();
        Page createdChildPage = this.quizPageManager.createPage(parent, event.getCreator(), parent.getDisplayTitle() + postfixForPage, body);
        return createdChildPage.getIdAsString();
    }
}

