/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.cache.DateFormatterCacheManager;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.Answer;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizResultsHelper {
    private static final Logger log = LoggerFactory.getLogger(QuizResultsHelper.class);
    private DateFormatterCacheManager dateFormatterCacheManager;
    private QuizService quizService;
    private UserEntityService userEntityService;
    private PageManager pageManager;
    private UserAccessor userAccessor;
    private Map<String, ConfluenceUser> userMap;

    public QuizResultsHelper(DateFormatterCacheManager dateFormatterCacheManager, QuizService quizService, UserEntityService userEntityService, PageManager pageManager, UserAccessor userAccessor) {
        this.dateFormatterCacheManager = dateFormatterCacheManager;
        this.quizService = quizService;
        this.userEntityService = userEntityService;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
    }

    public Answers getAnswersForCurrentUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return new Answers(new ArrayList<Answer>(), new ArrayList<Answer>(), new HashMap<Integer, List<Answer>>(), false);
        }
        return this.getAnswers(this.quizService.getUserStates(user.getKey().getStringValue()), false, true);
    }

    public Answers getAnswers(List<QuizStateEntity> entities, boolean setUser, boolean setUrl) {
        this.userMap = new HashMap<String, ConfluenceUser>();
        HashMap<Long, AbstractPage> pageMap = new HashMap<Long, AbstractPage>();
        ArrayList<Answer> incompleteAnswers = new ArrayList<Answer>();
        ArrayList<Answer> completeAnswers = new ArrayList<Answer>();
        HashMap<Integer, List<Answer>> oldAttempts = new HashMap<Integer, List<Answer>>();
        boolean usedInCourse = false;
        for (QuizStateEntity entity : entities) {
            Answer answer;
            if (pageMap.get(entity.getQuizId()) == null) {
                AbstractPage page = this.pageManager.getAbstractPage(entity.getQuizId().longValue());
                if (page == null || page.isDeleted()) continue;
                pageMap.put(entity.getQuizId(), page);
            }
            if (entity.getCourseId() != null && pageMap.get(entity.getCourseId()) == null) {
                pageMap.put(entity.getCourseId(), this.pageManager.getAbstractPage(entity.getCourseId().longValue()));
                usedInCourse = true;
            }
            if (oldAttempts.containsKey((answer = this.getAnswer(entity, pageMap, setUser, setUrl)).getSessionId())) {
                ((List)oldAttempts.get(answer.getSessionId())).add(answer);
                continue;
            }
            oldAttempts.put(answer.getSessionId(), new ArrayList());
            if (!answer.isComplete()) {
                incompleteAnswers.add(answer);
                continue;
            }
            completeAnswers.add(answer);
        }
        for (Answer answer : new ArrayList(incompleteAnswers)) {
            boolean isIncomplete = true;
            List oldAnswers = (List)oldAttempts.get(answer.getSessionId());
            if (oldAnswers != null) {
                for (Answer oldAnswer : oldAnswers) {
                    if (!oldAnswer.isComplete()) continue;
                    isIncomplete = false;
                    break;
                }
            }
            if (isIncomplete) continue;
            incompleteAnswers.remove(answer);
            completeAnswers.add(answer);
        }
        Collections.sort(incompleteAnswers);
        Collections.sort(completeAnswers);
        return new Answers(incompleteAnswers, completeAnswers, oldAttempts, usedInCourse);
    }

    private Answer getAnswer(QuizStateEntity entity, Map<Long, AbstractPage> pageMap, boolean userNeeded, boolean urlNeeded) {
        String studentKey;
        DateFormatter dateFormatter = this.dateFormatterCacheManager.getDateFormatter();
        Answer.AnswerBuilder answerBuilder = Answer.newBuilder().setEntity(entity).setPageMap(pageMap).setDateFormatter(dateFormatter).setAuthor(this.getUser(this.userEntityService.getUser(entity.getAuthor()).getKey()));
        if (userNeeded) {
            UserEntity userEntity = this.userEntityService.getUser(entity.getUserId());
            if (userEntity.getExternal().booleanValue()) {
                studentKey = userEntity.getKey();
                answerBuilder.setStudentEmail(userEntity.getKey());
                answerBuilder.setStudentName(userEntity.getName());
            } else {
                ConfluenceUser student = this.getUser(userEntity.getKey());
                studentKey = student.getKey().getStringValue();
                answerBuilder.setStudent(student);
            }
        } else {
            ConfluenceUser student = AuthenticatedUserThreadLocal.get();
            studentKey = student.getKey().getStringValue();
            answerBuilder.setStudent(student);
            answerBuilder.setRetakeOnFailEnabled(this.quizService.isRetakeOnFail(entity));
        }
        if (urlNeeded) {
            try {
                answerBuilder.setUrl(GeneralUtil.urlEncode((String)QuizEncrypter.encrypt(new MailParams(entity.getQuizId(), entity.getUserId(), entity.getAuthor(), studentKey, entity.getSessionId() == null ? entity.getID() : entity.getSessionId().intValue()))));
            }
            catch (Exception e) {
                log.error("Failed to create quiz link", (Throwable)e);
            }
        }
        return answerBuilder.build();
    }

    private ConfluenceUser getUser(String userKey) {
        if (!this.userMap.containsKey(userKey)) {
            this.userMap.put(userKey, this.userAccessor.getUserByKey(new UserKey(userKey)));
        }
        return this.userMap.get(userKey);
    }

    public class Answers {
        private List<Answer> incompleteAnswers;
        private List<Answer> completeAnswers;
        private Map<Integer, List<Answer>> oldAttempts;
        private boolean usedInCourse;

        public Answers(List<Answer> incompleteAnswers, List<Answer> completeAnswers, Map<Integer, List<Answer>> oldAttempts, boolean usedInCourse) {
            this.incompleteAnswers = incompleteAnswers;
            this.completeAnswers = completeAnswers;
            this.oldAttempts = oldAttempts;
            this.usedInCourse = usedInCourse;
        }

        public List<Answer> getIncompleteAnswers() {
            return this.incompleteAnswers;
        }

        public List<Answer> getCompleteAnswers() {
            return this.completeAnswers;
        }

        public List<Answer> getAllAnswers() {
            return Stream.concat(this.incompleteAnswers.stream(), this.completeAnswers.stream()).collect(Collectors.toList());
        }

        public Map<Integer, List<Answer>> getOldAttempts() {
            return this.oldAttempts;
        }

        public boolean isUsedInCourse() {
            return this.usedInCourse;
        }

        public boolean hasIncompleteAnswers() {
            return !this.incompleteAnswers.isEmpty();
        }
    }
}

