/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.RenderContext;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.cache.AttachmentsCacheManager;
import com.stiltsoft.confluence.quiz.entity.AttachmentParams;
import com.stiltsoft.confluence.quiz.entity.MailParams;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizPageManager {
    private static final Logger log = LoggerFactory.getLogger(QuizPageManager.class);
    private static final Pattern ATTACHMENT = Pattern.compile("<[^<>]*=\"([^<>]*?(/download/(attachments|thumbnails)/(\\d+)).*?)\".*?>", 32);
    private static final Pattern CONVERSION_THUMBNAIL = Pattern.compile("<img [^<>]*src=\"[^<>]*?(/rest/documentConversion/latest/conversion/thumbnail/(\\d+).*?)\" .*?");
    private static final Pattern FEEDBACK = Pattern.compile("<div class=\"quiz-feedback-container(.+?)>.*?<span id=\"quiz-feedback-container-terminator\">[\\r\\n\\s]*</span>[\\r\\n\\s]*</div>", 32);
    private static final Pattern ANSWER = Pattern.compile("<div class=\"quiz-answer-container(.+?)>[\\S\\r\\n\\s]*?<span class=\"quiz-answer-terminator\">[\\S\\r\\n\\s]*?</span>[\\S\\r\\n\\s]*?</div>", 32);
    private static final Pattern ANSWER_POSSIBLE_HEADER = Pattern.compile("<h3 class=\"possible-correct-answers\">.*?</h3>");
    private static final Pattern CORRECT_FEEDBACK = Pattern.compile("<div id=\"quiz-feedback-body-correct\">.*?<span id=\"quiz-feedback-body-terminator\">[\\r\\n\\s]*</span>[\\r\\n\\s]*</div>", 32);
    private static final Pattern WRONG_FEEDBACK = Pattern.compile("<div id=\"quiz-feedback-body-wrong\">.*?<span id=\"quiz-feedback-body-terminator\">[\\r\\n\\s]*</span>[\\r\\n\\s]*</div>", 32);
    private static final Pattern DRAWIO = Pattern.compile("/rest/drawio/1.0/diagram/crud/(.+?/\\d+\\?revision=\\d+)", 32);
    private PageManager pageManager;
    private QuizMacroManager quizMacroManager;
    private FormatConverter converter;
    private ConfluenceIndexer indexer;
    private AttachmentsCacheManager cacheManager;
    private AttachmentManager attachmentManager;

    public QuizPageManager(PageManager pageManager, QuizMacroManager quizMacroManager, FormatConverter converter, ConfluenceIndexer indexer, AttachmentsCacheManager cacheManager, AttachmentManager attachmentManager) {
        this.pageManager = pageManager;
        this.quizMacroManager = quizMacroManager;
        this.converter = converter;
        this.indexer = indexer;
        this.cacheManager = cacheManager;
        this.attachmentManager = attachmentManager;
    }

    public Page createPage(Page parent, ConfluenceUser creator, String title, String body) {
        Page page = new Page();
        page.setSpace(parent.getSpace());
        page.setCreationDate(new Date());
        page.setCreator(creator);
        page.setTitle(title);
        page.setBodyAsString(body);
        parent.addChild(page);
        page.setParentPage(parent);
        this.pageManager.saveContentEntity((ContentEntityObject)page, null);
        this.indexer.index((Searchable)page);
        this.indexer.reIndex((Searchable)parent);
        return page;
    }

    public MutablePair<String, AbstractPage> getFinishPage(QuizStateEntity entity, ConfluenceUser user, MailParams mailParams) throws Exception {
        if (entity.getStatus() != 2) {
            return new MutablePair((Object)"", null);
        }
        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)this.pageManager.getPage(entity.getQuizId().longValue()));
        Long id = entity.getReview() != null && entity.getReview() > 0 ? params.getReviewPageId() : (entity.getCorrect() >= entity.getTarget() ? params.getSuccessPageId() : params.getFailPageId());
        if (id == null) {
            return new MutablePair((Object)"", null);
        }
        return this.renderPage(id, null, user, mailParams);
    }

    public MutablePair<String, AbstractPage> getStartPage(QuizStateEntity entity, ConfluenceUser user, MailParams mailParams) throws Exception {
        QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)this.pageManager.getAbstractPage(entity.getQuizId().longValue()));
        Long id = params.getStartPageId();
        if (id == null) {
            return new MutablePair((Object)"", null);
        }
        return this.renderPage(id, null, user, mailParams);
    }

    public MutablePair<String, AbstractPage> renderPage(long id, Integer pageVersion, ConfluenceUser user, MailParams params) throws Exception {
        AbstractPage page = this.pageManager.getAbstractPage(id);
        if (pageVersion != null) {
            page = this.pageManager.getPageByVersion(page, pageVersion.intValue());
        }
        return this.renderPage(page, user, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutablePair<String, AbstractPage> renderPage(AbstractPage page, ConfluenceUser user, MailParams params) throws Exception {
        if (page == null || page.isDeleted()) {
            return new MutablePair((Object)"", (Object)page);
        }
        PageContext context = page.toPageContext();
        context.getParams().put("quiz", true);
        ConfluenceUser viewer = AuthenticatedUserThreadLocal.get();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        String body = "";
        try {
            body = this.converter.convertToViewFormat(page.getBodyAsString(), (RenderContext)context);
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)viewer);
        }
        body = this.extractAttachments(body, params, page.getId());
        body = this.extractDRAWIO(body, params, page.getId());
        body = this.updateAnchorLinks(body);
        return new MutablePair((Object)body, (Object)page);
    }

    public List<String> getAnswersOptions(ContentEntityObject page) {
        List<String> options = this.quizMacroManager.getAnswersOptions(page);
        ArrayList<String> renderedOptions = new ArrayList<String>();
        for (String option : options) {
            try {
                renderedOptions.add(this.extractAttachments(this.converter.convertToViewFormat(option, (RenderContext)page.toPageContext()), new MailParams(), page.getId()));
            }
            catch (Exception e) {
                log.error("Failed to render answer option: pageId=" + page.getId(), (Throwable)e);
            }
        }
        return renderedOptions;
    }

    public String removeFeedback(String body) {
        Matcher matcher = FEEDBACK.matcher(body);
        while (matcher.find()) {
            body = body.replace(matcher.group(0), "");
        }
        return body;
    }

    public List<String> getAnswers(String body) {
        ArrayList<String> answers = new ArrayList<String>();
        Matcher matcher = ANSWER.matcher(body);
        while (matcher.find()) {
            answers.add(matcher.group(0));
        }
        return answers;
    }

    public List<String> getEncodedAnswersOptionTexts(AbstractPage page) {
        return this.quizMacroManager.getAnswersOptions((ContentEntityObject)page).stream().map(text -> {
            try {
                return URLEncoder.encode(text.replaceAll(".*?<p>(.*?)</p>.*", "$1").toLowerCase().trim(), StandardCharsets.UTF_8.toString());
            }
            catch (Exception e) {
                return "";
            }
        }).filter(text -> !text.isEmpty()).collect(Collectors.toList());
    }

    public String removeAnswers(String body) {
        return body.replaceAll(ANSWER.pattern(), "").replaceAll(ANSWER_POSSIBLE_HEADER.pattern(), "");
    }

    public String getFeedBack(Long pageId, Integer pageVersion, boolean isCorrect, ConfluenceUser user, MailParams params) throws Exception {
        String body = (String)this.renderPage(pageId, pageVersion, user, params).getLeft();
        String feedback = "";
        if (isCorrect) {
            Matcher matcher = CORRECT_FEEDBACK.matcher(body);
            if (matcher.find()) {
                feedback = matcher.group(0);
            }
        } else {
            Matcher matcher = WRONG_FEEDBACK.matcher(body);
            if (matcher.find()) {
                feedback = matcher.group(0);
            }
        }
        return feedback;
    }

    public String extractAttachments(String body, MailParams params, Long pageId) throws Exception {
        Matcher matcher = ATTACHMENT.matcher(body);
        Random random = new Random();
        while (matcher.find() && !matcher.group(1).endsWith("/user-avatar")) {
            try {
                String url = matcher.group(1);
                if (!url.contains("?")) {
                    url = url + "?";
                }
                Attachment attachment = (Attachment)this.attachmentManager.getAttachmentForDownloadPath(url).get();
                long attachmentId = attachment.getId();
                AttachmentParams attachmentParams = new AttachmentParams(params, pageId, random.nextInt(), matcher.group(4));
                this.cacheManager.add(attachmentId, attachmentParams);
                String descriptor = QuizEncrypter.encryptAsEncodedUrl(attachmentParams);
                String oldUrl = matcher.group(2).replace("/thumbnails/", "/attachments/");
                String newUrl = "/plugins/servlet/quiz" + oldUrl.replace(matcher.group(4), descriptor);
                String tag = matcher.group(0).replace(oldUrl, newUrl);
                tag = tag.replace(oldUrl.replace("/attachments/", "/thumbnails/"), newUrl);
                if (!(body = body.replace(matcher.group(0), tag)).contains("data-attachment-id=\"" + attachmentId + "\"")) continue;
                body = body.replace("data-attachment-id=\"" + attachmentId + "\"", "data-attachment-id=\"" + descriptor + "\"");
            }
            catch (Exception e) {
                log.error("Failed to extract attachment", (Throwable)e);
            }
        }
        matcher = CONVERSION_THUMBNAIL.matcher(body);
        while (matcher.find()) {
            long attachmentId = Long.parseLong(matcher.group(2));
            AttachmentParams attachmentParams = new AttachmentParams(params, pageId, random.nextInt(), matcher.group(2));
            this.cacheManager.add(attachmentId, attachmentParams);
            String descriptor = QuizEncrypter.encryptAsEncodedUrl(attachmentParams);
            String newUrl = "/plugins/servlet/quiz" + matcher.group(1).replace(matcher.group(2), descriptor);
            String tag = matcher.group(0).replace(matcher.group(1), newUrl);
            body = body.replace(matcher.group(0), tag);
        }
        return body;
    }

    private String extractDRAWIO(String body, MailParams params, Long pageId) {
        Matcher matcher = DRAWIO.matcher(body);
        Random random = new Random();
        while (matcher.find()) {
            try {
                DiagramParams diagramParams = new DiagramParams(matcher.group(1));
                AttachmentParams attachmentParams = new AttachmentParams(params, pageId, random.nextInt(), diagramParams.getPageId());
                this.cacheManager.add(attachmentParams.getUserId().intValue(), attachmentParams);
                String descriptor = QuizEncrypter.encryptAsEncodedUrl(attachmentParams);
                body = this.setSimpleViewer(body);
                body = this.setDiagramProxy(descriptor, diagramParams, body);
            }
            catch (Exception e) {
                log.error("Failed to extract DrawIO", (Throwable)e);
            }
        }
        return body;
    }

    private String setSimpleViewer(String body) {
        return body.replace("readerOpts.simpleViewer = false", "readerOpts.simpleViewer = true");
    }

    private String setDiagramProxy(String descriptor, DiagramParams diagramParams, String body) throws UnsupportedEncodingException {
        String attachmentsURL = "/download/attachments/" + diagramParams.getPageId() + "/" + URLDecoder.decode(diagramParams.getName(), StandardCharsets.UTF_8.toString()) + ".png";
        String proxyURL = "/plugins/servlet/quiz/download/attachments/" + descriptor + "/" + diagramParams.getName() + ".png";
        return body.replace(attachmentsURL, proxyURL);
    }

    private String updateAnchorLinks(String body) {
        return body.replaceAll("(<a.*?href=\"#.*?\".*?)target=\".*?\"(.*?>)", "$1$2").replaceAll("(<a.*?href=\"#.*?\".*?)>", "$1 target=\"_self\">");
    }

    private static class DiagramParams {
        private final String name;
        private final String pageId;

        public DiagramParams(String diagramPath) throws IllegalArgumentException {
            if (!diagramPath.matches("^[^/]*/[^/]*")) {
                throw new IllegalArgumentException("Invalid drawIO diagram path: " + diagramPath);
            }
            String[] parts = diagramPath.split("/");
            this.pageId = parts[1].split("\\?")[0];
            this.name = parts[0];
        }

        public String getName() {
            return this.name;
        }

        public String getPageId() {
            return this.pageId;
        }
    }
}

