/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizMediaInserter {
    private static final Logger log = LoggerFactory.getLogger(QuizMediaInserter.class);
    private static final Pattern ATTACHMENT = Pattern.compile("\\$\\{(.*?)(\\|(width|height)=(\\d+))?}", 32);
    private FileUploadManager fileUploadManager;
    private XhtmlContent xhtmlContent;

    public QuizMediaInserter(FileUploadManager fileUploadManager, XhtmlContent xhtmlContent) {
        this.fileUploadManager = fileUploadManager;
        this.xhtmlContent = xhtmlContent;
    }

    public String createMediaMacros(String body, ConversionContext context) {
        Matcher matcher = ATTACHMENT.matcher(body);
        while (matcher.find()) {
            String attribute = "";
            if (matcher.group(2) != null) {
                attribute = "|" + matcher.group(3) + "=" + matcher.group(4);
            }
            String macro = "!" + matcher.group(1) + attribute + "!";
            body = body.replace(matcher.group(0), macro);
        }
        return this.xhtmlContent.convertWikiToStorage(body, context, new ArrayList());
    }

    public void attachMedia(Page page, String body) {
        Matcher matcher = ATTACHMENT.matcher(body);
        while (matcher.find()) {
            File file = new File(matcher.group(1));
            String name = file.getName();
            try {
                String mime = Files.probeContentType(file.toPath());
                FileInputStream stream = new FileInputStream(matcher.group(1));
                InputStreamAttachmentResource resource = new InputStreamAttachmentResource((InputStream)stream, name, mime, file.length());
                this.fileUploadManager.storeResource((AttachmentResource)resource, (ContentEntityObject)page);
            }
            catch (Exception e) {
                log.error("Failed to store file", (Throwable)e);
            }
        }
    }
}

