/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.util.concurrent.atomic.AtomicReference;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizMacroManager {
    private static final Logger log = LoggerFactory.getLogger(QuizMacroManager.class);
    private PageManager pageManager;
    private XhtmlContent xhtmlContent;

    public QuizMacroManager(PageManager pageManager, XhtmlContent xhtmlContent) {
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
    }

    public QuizParams getQuizParams(long pageId) {
        try {
            return this.getQuizParams((ContentEntityObject)this.pageManager.getAbstractPage(pageId));
        }
        catch (XhtmlException e) {
            log.error("Failed to get quiz params: quizId=" + pageId, (Throwable)e);
            return null;
        }
    }

    public QuizParams getQuizParams(ContentEntityObject page) throws XhtmlException {
        if (page == null) {
            return null;
        }
        final AtomicReference atomicMacroDefinition = new AtomicReference();
        this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext()), new MacroDefinitionHandler(){

            public void handle(MacroDefinition macroDefinition) {
                if ("quiz-settings".equals(macroDefinition.getName()) || "share-quiz".equals(macroDefinition.getName()) && atomicMacroDefinition.get() == null) {
                    atomicMacroDefinition.set((Object)macroDefinition);
                }
            }
        });
        MacroDefinition macro = (MacroDefinition)atomicMacroDefinition.get();
        if (macro == null) {
            return new QuizParams();
        }
        return new QuizParams(macro.getParameter("labels"), macro.getParameter("count"), macro.getParameter("target"), macro.getParameter("timelimit"), macro.getParameter("attempts"), macro.getParameter("show-res"), macro.getParameter("show-feedback"), macro.getParameter("random"), macro.getParameter("skip"), macro.getParameter("desc"), macro.getParameter("authors"), macro.getParameter("success-page-id"), macro.getParameter("fail-page-id"), macro.getParameter("review-page-id"), macro.getParameter("questions-order"), macro.getParameter("anonymous"), macro.getParameter("skip-start-page"), macro.getParameter("start-page-id"), macro.getParameter("resubmit"), macro.getParameter("anonymous-confirmation"), macro.getParameter("disable-user-notification"), macro.getParameter("disable-take-notification"), macro.getParameter("due-date"), macro.getParameter("due-days"), macro.getParameter("retake-on-fail"), macro.getParameter("show-answers"), macro.getParameter("enrollment-reminder"), macro.getParameter("enrollment-reminder-msg"), macro.getParameter("duedate-reminder"), macro.getParameter("duedate-reminder-msg"));
    }

    public QuestionParams getQuestionParam(ContentEntityObject page) throws XhtmlException {
        final AtomicReference atomicMacroDefinition = new AtomicReference();
        this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext()), new MacroDefinitionHandler(){

            public void handle(MacroDefinition macroDefinition) {
                if ("quiz-answers".equals(macroDefinition.getName()) && atomicMacroDefinition.get() == null) {
                    atomicMacroDefinition.set((Object)macroDefinition);
                }
            }
        });
        MacroDefinition macro = (MacroDefinition)atomicMacroDefinition.get();
        if (macro == null) {
            return new QuestionParams();
        }
        return new QuestionParams(macro.getParameter("random"), macro.getParameter("type"));
    }

    public List<String> getAnswersOptions(ContentEntityObject page) {
        final ArrayList<String> options = new ArrayList<String>();
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)page.toPageContext());
        try {
            this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)context, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    if ("quiz-answer-variant".equals(macroDefinition.getName())) {
                        options.add(Streamables.writeToString((Streamable)macroDefinition.getBody().getStorageBodyStream()));
                    }
                }
            });
        }
        catch (XhtmlException e) {
            log.error("Failed to get answer options: pageId=" + page.getId(), (Throwable)e);
        }
        return options;
    }

    public Optional<Map<String, String>> getQuizAnswersReportParams(ContentEntityObject page, final String macroId) {
        if (StringUtils.isBlank((CharSequence)macroId)) {
            return Optional.empty();
        }
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)page.toPageContext());
        final AtomicReference macroParams = new AtomicReference();
        try {
            this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)context, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    String currentMacroId;
                    if ("quiz-answers-report".equals(macroDefinition.getName()) && macroDefinition.getMacroId().isDefined() && (currentMacroId = ((MacroId)macroDefinition.getMacroId().get()).getId()).equals(macroId)) {
                        macroParams.set((Object)macroDefinition.getParameters());
                    }
                }
            });
        }
        catch (XhtmlException e) {
            log.error("Failed to get quiz results report options: pageId=" + page.getId(), (Throwable)e);
        }
        return Optional.ofNullable(macroParams.get());
    }

    public String renderQuestionsReportMacro(ContentEntityObject page) throws XhtmlException {
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)page.toPageContext());
        final AtomicReference macroDefinitionAtomicReference = new AtomicReference();
        this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)context, new MacroDefinitionHandler(){

            public void handle(MacroDefinition macroDefinition) {
                if ("quiz-questions-report".equals(macroDefinition.getName())) {
                    macroDefinitionAtomicReference.set((Object)macroDefinition);
                }
            }
        });
        return this.xhtmlContent.convertMacroDefinitionToView((MacroDefinition)macroDefinitionAtomicReference.get(), (ConversionContext)context);
    }
}

