/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.ReminderService;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizFinishedStatus;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.mail.MailSender;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.DueDateHelper;
import com.stiltsoft.confluence.quiz.workbox.WorkboxManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizHelper {
    private static final Logger log = LoggerFactory.getLogger(QuizHelper.class);
    private QuizService quizService;
    private UserEntityService userEntityService;
    private DueDateHelper dueDateHelper;
    private MailSender mailSender;
    private WorkboxManager workboxManager;
    private UserAccessor userAccessor;
    private PageManager pageManager;
    private QuizMacroManager quizMacroManager;
    private ReminderService reminderService;
    private TransactionTemplate transactionTemplate;

    public QuizHelper(QuizService quizService, UserEntityService userEntityService, DueDateHelper dueDateHelper, MailSender mailSender, WorkboxManager workboxManager, UserAccessor userAccessor, PageManager pageManager, QuizMacroManager quizMacroManager, ReminderService reminderService, TransactionTemplate transactionTemplate) {
        this.quizService = quizService;
        this.userEntityService = userEntityService;
        this.dueDateHelper = dueDateHelper;
        this.mailSender = mailSender;
        this.workboxManager = workboxManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.quizMacroManager = quizMacroManager;
        this.reminderService = reminderService;
        this.transactionTemplate = transactionTemplate;
    }

    public void enroll(final QuizParams params, List<AbstractPage> quizQuestions, final List<ConfluenceUser> participants, final Page quizPage, final ConfluenceUser author) {
        ArrayList<RecordParams> recordParams = new ArrayList<RecordParams>();
        for (ConfluenceUser participant : participants) {
            recordParams.add(this.getRecordParams(params, quizQuestions, (ConfluenceUser)(participant.getName() != null ? participant : null), participant.getKey().getStringValue(), participant.getEmail()));
        }
        int authorId = this.userEntityService.getUserId(author.getKey().getStringValue());
        final List<QuizStateEntity> entities = this.quizService.setTests(quizPage.getId(), authorId, params, recordParams);
        new Thread(new Runnable(){

            @Override
            public void run() {
                QuizHelper.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() {
                        Page page = QuizHelper.this.pageManager.getPage(quizPage.getId());
                        for (int i = 0; i < participants.size(); ++i) {
                            try {
                                ConfluenceUser participant = (ConfluenceUser)participants.get(i);
                                QuizHelper.this.createNotifications((QuizStateEntity)entities.get(i), params, (ConfluenceUser)(participant.getName() != null ? participant : null), participant.getKey().getStringValue(), participant.getEmail(), page, author, false);
                                continue;
                            }
                            catch (Exception e) {
                                log.error("Failed to create quiz notification", (Throwable)e);
                            }
                        }
                        return null;
                    }
                });
            }
        }).start();
    }

    public Integer createQuizRecord(QuizParams params, List<AbstractPage> quizQuestions, ConfluenceUser user, String userKey, String mail, String userName, Page quizPage, ConfluenceUser author, boolean isSelfEnrollment) throws Exception {
        return this.createQuizRecord(params, quizQuestions, user, userKey, mail, userName, quizPage, author, isSelfEnrollment, null, null);
    }

    public Integer createQuizRecord(QuizParams params, List<AbstractPage> quizQuestions, ConfluenceUser user, String userKey, String mail, String userName, Page quizPage, ConfluenceUser author, boolean isSelfEnrollment, Long courseId, Integer courseRecord) throws Exception {
        QuizStateEntity entity = this.createRecord(params, quizQuestions, user, userKey, userName, quizPage, author, isSelfEnrollment, courseId, courseRecord);
        this.createNotifications(entity, params, user, userKey, mail, quizPage, author, isSelfEnrollment);
        return entity.getID();
    }

    public List<Long> getQuestionsSet(QuizParams params, List<AbstractPage> quizQuestions) {
        Random random = new Random();
        params.setCount(Math.min(params.getCount(), quizQuestions.size()));
        params.setTarget(Math.min(params.getCount(), params.getTarget()));
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>(quizQuestions);
        ArrayList<Long> questions = new ArrayList<Long>(params.getCount());
        while (questions.size() < params.getCount()) {
            int n = params.isRandom() ? random.nextInt(pages.size()) : 0;
            Long id = ((Searchable)pages.get(n)).getId();
            pages.remove(n);
            questions.add(id);
        }
        return questions;
    }

    public void notifyOnCompletion(QuizStateEntity entity) throws Exception {
        this.notifyOnCompletion(entity, new QuizFinishedStatus(entity, false, false));
    }

    public void notifyOnCompletion(QuizStateEntity entity, QuizFinishedStatus status) throws Exception {
        if (entity.getStatus() == 2) {
            String name;
            String email;
            Page quizPage = this.pageManager.getPage(entity.getQuizId().longValue());
            Page coursePage = entity.getCourseId() != null ? this.pageManager.getPage(entity.getCourseId().longValue()) : null;
            QuizParams params = this.quizMacroManager.getQuizParams((ContentEntityObject)quizPage);
            List<String> keys = params.getAuthorsKeys();
            UserEntity userEntity = this.userEntityService.getUser(entity.getUserId());
            String userKey = userEntity.getKey();
            ConfluenceUser student = null;
            if (userEntity.getExternal().booleanValue()) {
                email = userEntity.getKey();
                name = userEntity.getKey();
            } else {
                student = this.userAccessor.getUserByKey(new UserKey(userKey));
                email = student.getEmail();
                name = student.getFullName();
            }
            for (String key : keys) {
                ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(key));
                if (status.isReview()) {
                    this.mailSender.sendWaitingReviewAuthors(name, email, student, author, quizPage, entity, coursePage);
                    continue;
                }
                if (coursePage != null) continue;
                this.mailSender.sendAnsweredAuthors(name, email, student, author, quizPage, entity.getUserId(), entity.getID(), entity.getStartDate(), entity.getTotal(), entity.getTarget(), entity.getCorrect(), status);
            }
            if (!params.isDisableUserNotification() && coursePage == null && !status.isReview()) {
                UserEntity authorEntity = this.userEntityService.getUser(entity.getAuthor());
                ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(authorEntity.getKey()));
                this.mailSender.sendCompleted(email, userKey, quizPage, entity, student, author, params);
            }
        }
    }

    private QuizStateEntity createRecord(QuizParams params, List<AbstractPage> quizQuestions, ConfluenceUser user, String userKey, String userName, Page quizPage, ConfluenceUser author, boolean isSelfEnrollment, Long courseId, Integer courseRecord) {
        int authorId = this.userEntityService.getUserId(author.getKey().getStringValue());
        RecordParams recordParams = this.getRecordParams(params, quizQuestions, user, userKey, userName);
        return this.quizService.setTest(recordParams.userId, quizPage.getId(), authorId, recordParams.questions, params, recordParams.dueDate, isSelfEnrollment, courseId, courseRecord);
    }

    private void createNotifications(QuizStateEntity entity, QuizParams params, ConfluenceUser user, String userKey, String mail, Page quizPage, ConfluenceUser author, boolean isSelfEnrollment) throws Exception {
        boolean anonymousEmailConfirmation;
        boolean bl = anonymousEmailConfirmation = params.isAnonymousConfirmation() || params.isAnonymous();
        if (!isSelfEnrollment || !mail.isEmpty() && (!params.isDisableTakeNotification() || !anonymousEmailConfirmation && user == null)) {
            String formattedDueDate = this.dueDateHelper.formatDueDate(entity.getDueDate(), user);
            this.mailSender.send(mail, userKey, quizPage, entity.getUserId(), author, entity.getAuthor(), params.getDesc(), entity.getID(), isSelfEnrollment, formattedDueDate);
        }
        if (user != null && !isSelfEnrollment) {
            this.workboxManager.addQuizNotification(user, author, (AbstractPage)quizPage, entity.getUserId(), entity.getAuthor(), entity.getID(), params.getDesc());
        }
        if (!mail.isEmpty()) {
            this.reminderService.setQuizReminders(params, entity);
        }
    }

    private RecordParams getRecordParams(QuizParams params, List<AbstractPage> quizQuestions, ConfluenceUser user, String userKey, String userName) {
        int userId = this.userEntityService.getUserId(userKey, userName);
        List<Long> questions = this.getQuestionsSet(params, quizQuestions);
        Long dueDate = this.dueDateHelper.getUserDueDate(user, params.getDueDate());
        return new RecordParams(userId, questions, dueDate);
    }

    public class RecordParams {
        private int userId;
        private List<Long> questions;
        private Long dueDate;

        public RecordParams(int userId, List<Long> questions, Long dueDate) {
            this.userId = userId;
            this.questions = questions;
            this.dueDate = dueDate;
        }

        public int getUserId() {
            return this.userId;
        }

        public List<Long> getQuestions() {
            return this.questions;
        }

        public Long getDueDate() {
            return this.dueDate;
        }
    }
}

