/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.cache.AttachmentsCacheManager;
import com.stiltsoft.confluence.quiz.entity.AttachmentParams;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.QuizEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizAttachmentManager {
    private static final Logger log = LoggerFactory.getLogger(QuizAttachmentManager.class);
    private AttachmentsCacheManager cacheManager;
    private UserEntityService userEntityService;
    private QuizService quizService;
    private CourseStateEntityService courseStateEntityService;
    private ConfluencePermissionHelper confluencePermissionHelper;

    public QuizAttachmentManager(AttachmentsCacheManager cacheManager, UserEntityService userEntityService, QuizService quizService, CourseStateEntityService courseStateEntityService, ConfluencePermissionHelper confluencePermissionHelper) {
        this.cacheManager = cacheManager;
        this.userEntityService = userEntityService;
        this.quizService = quizService;
        this.courseStateEntityService = courseStateEntityService;
        this.confluencePermissionHelper = confluencePermissionHelper;
    }

    public Long getAttachmentId(String descriptor) {
        AttachmentParams params;
        if (descriptor.length() < 16) {
            log.warn(String.format("ATTACHMENT ERROR: DESCRIPTOR.length() < 16, descriptor=%s", descriptor));
            return null;
        }
        try {
            params = QuizEncrypter.decryptAttachmentParams(descriptor);
        }
        catch (Exception e) {
            log.error("ATTACHMENT ERROR: Failed to parse descriptor", (Throwable)e);
            return null;
        }
        if (params.getRecordId() != -1 && this.quizService.getStateTx(params.getUserId(), params.getQuizId(), params.getAuthorId(), params.getRecordId()) == null && !this.courseStateEntityService.getCourseEnrollWrapper(params.getUserId(), params.getQuizId(), params.getRecordId()).isPresent()) {
            log.warn(String.format("ATTACHMENT ERROR: ENROLL NOT FOUND attachmentParams=%s", params));
            return null;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (params.getUserId() != -1) {
            UserEntity userEntity = this.userEntityService.getUser(params.getUserId());
            if (user == null) {
                if (!userEntity.getExternal().booleanValue() && this.confluencePermissionHelper.canUseConfluence(userEntity)) {
                    log.warn(String.format("ATTACHMENT ERROR: USER NOT EXIST. USER_ENTITY ISN'T EXTERNAL. USER_ENTITY CAN USE CONFLUENCE attachmentParams=%s userEntity.key=%s userEntity.id=%d", params, userEntity.getKey(), userEntity.getID()));
                    return null;
                }
            } else {
                if (userEntity.getExternal().booleanValue()) {
                    log.warn(String.format("ATTACHMENT ERROR: USER EXISTS AND USER_ENTITY IS EXTERNAL attachmentParams=%s user.key=%s userEntity.key=%s", params, user.getKey().getStringValue(), userEntity.getKey()));
                    return null;
                }
                if (!user.getKey().getStringValue().equals(userEntity.getKey())) {
                    log.warn(String.format("ATTACHMENT ERROR: USER_KEY DOESN'T MATCH attachmentParams=%s user.key=%s userEntity.key=%s", params, user.getKey().getStringValue(), userEntity.getKey()));
                    return null;
                }
            }
        }
        return this.cacheManager.get(params);
    }

    public String getUrlParam(String descriptor) {
        try {
            return QuizEncrypter.decryptAttachmentParams(descriptor).getUrlParam();
        }
        catch (Exception e) {
            log.error("ATTACHMENT ERROR: Failed to to parse descriptor", (Throwable)e);
            return null;
        }
    }
}

