/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.GroupManager;
import com.google.common.collect.Lists;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.Answer;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.AnswerVariants;
import com.stiltsoft.confluence.quiz.entity.quiz.answer.AnswersReport;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import com.stiltsoft.confluence.quiz.manager.QuizPageManager;
import com.stiltsoft.confluence.quiz.manager.QuizResultsHelper;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.utils.MacroParameterResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuizAnswersHelper {
    private static final Logger log = LoggerFactory.getLogger(QuizAnswersHelper.class);
    private QuizService quizService;
    private PageManager pageManager;
    private QuizPageManager quizPageManager;
    private QuizMacroManager quizMacroManager;
    private UserEntityService userEntityService;
    private UserAccessor userAccessor;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private GroupManager groupManager;
    private QuizResultsHelper quizResultsHelper;
    private MacroParameterResolver macroParameterResolver;
    private Map<String, List<String>> questionVariant;
    private Map<Long, AbstractPage> questions;
    private Map<String, String> questionTypes;

    public QuizAnswersHelper(QuizService quizService, PageManager pageManager, QuizPageManager quizPageManager, QuizMacroManager quizMacroManager, UserEntityService userEntityService, UserAccessor userAccessor, ConfluenceContentSearcher confluenceContentSearcher, GroupManager groupManager, QuizResultsHelper quizResultsHelper, MacroParameterResolver macroParameterResolver) {
        this.quizService = quizService;
        this.pageManager = pageManager;
        this.quizPageManager = quizPageManager;
        this.quizMacroManager = quizMacroManager;
        this.userEntityService = userEntityService;
        this.userAccessor = userAccessor;
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.groupManager = groupManager;
        this.quizResultsHelper = quizResultsHelper;
        this.macroParameterResolver = macroParameterResolver;
        this.questionVariant = new HashMap<String, List<String>>();
        this.questions = new LinkedHashMap<Long, AbstractPage>();
        this.questionTypes = new HashMap<String, String>();
    }

    public AnswersReport buildReport(Map<String, String> params, ContentEntityObject ceo) {
        List<Long> quizIds = this.macroParameterResolver.resolveQuizzesIds(params, ceo);
        List<Integer> studentIds = this.macroParameterResolver.resolveStudentsIds(params);
        AnswersReport report = new AnswersReport(ceo.getId(), quizIds);
        QuizAnswersHelper answersHelper = new QuizAnswersHelper(this.quizService, this.pageManager, this.quizPageManager, this.quizMacroManager, this.userEntityService, this.userAccessor, this.confluenceContentSearcher, this.groupManager, this.quizResultsHelper, this.macroParameterResolver);
        boolean showAnswers = Boolean.parseBoolean(params.get("show-answers"));
        for (Long quizId : quizIds) {
            List<QuizStateEntity> entities = this.quizService.getStates(quizId, studentIds);
            QuizResultsHelper.Answers answersResults = this.quizResultsHelper.getAnswers(entities, true, false);
            report.addAnswers(quizId, answersResults);
            if (!showAnswers) continue;
            ArrayList<Answer> quizAnswers = new ArrayList<Answer>(answersResults.getAllAnswers());
            for (Answer answer : quizAnswers) {
                answer.setVariants(answersHelper.getVariants(answer));
            }
        }
        report.setQuestionPagesMap(answersHelper.getQuestions());
        report.setColumns(params.get("columns"));
        return report;
    }

    private Map<Long, AnswerVariants> getVariants(Answer answer) {
        HashMap<Long, AnswerVariants> variants = new HashMap<Long, AnswerVariants>();
        if (answer.getAllQuestions() != null && !answer.getAllQuestions().isEmpty()) {
            for (String id : answer.getAllQuestions().split(",")) {
                long pageId = Long.parseLong(id);
                this.updateQuestions(pageId);
                variants.put(pageId, new AnswerVariants(true));
            }
        }
        for (QuizAnswersEntity answersEntity : this.quizService.getAnswers(answer.getStudentId(), answer.getQuizId(), answer.getStartedMs())) {
            String userAnswer = answersEntity.getAnswers();
            String questionId = answersEntity.getQuestionId() + "-" + answersEntity.getPageVersion();
            this.updateQuestions(answersEntity.getQuestionId());
            AnswerVariants answerVariants = new AnswerVariants();
            if (!Boolean.TRUE.equals(answersEntity.getReviewable())) {
                ArrayList sequence;
                ArrayList optionNumbers = Lists.newArrayList((Object[])userAnswer.split(","));
                optionNumbers.remove("");
                ArrayList arrayList = sequence = answersEntity.getSequence() == null ? null : Lists.newArrayList((Object[])answersEntity.getSequence().split(","));
                if (!this.questionVariant.containsKey(questionId)) {
                    AbstractPage page = this.pageManager.getPageByVersion(this.questions.get(answersEntity.getQuestionId()), answersEntity.getPageVersion().intValue());
                    this.questionVariant.put(questionId, this.quizPageManager.getAnswersOptions((ContentEntityObject)page));
                    try {
                        this.questionTypes.put(questionId, this.quizMacroManager.getQuestionParam((ContentEntityObject)page).getType());
                    }
                    catch (XhtmlException e) {
                        log.error("Failed to get question type", (Throwable)e);
                    }
                }
                List<String> allOptions = this.questionVariant.get(questionId);
                for (String n : optionNumbers) {
                    int number;
                    if (n.isEmpty() || (number = (sequence == null ? Integer.valueOf(n) : Integer.valueOf(sequence.indexOf(n))).intValue()) < 0 || number >= allOptions.size()) continue;
                    answerVariants.addVariant(allOptions.get(number));
                }
                if (this.questionTypes.get(questionId) != null) {
                    answerVariants.setType(this.questionTypes.get(questionId));
                }
            } else {
                answerVariants.addVariant(GeneralUtil.htmlEncode((String)userAnswer));
                answerVariants.setType("Free text");
            }
            variants.put(answersEntity.getQuestionId(), answerVariants);
        }
        return variants;
    }

    public Map<Long, AbstractPage> getQuestions() {
        return this.questions;
    }

    private void updateQuestions(long pageId) {
        if (!this.questions.containsKey(pageId)) {
            AbstractPage question = this.pageManager.getAbstractPage(pageId);
            this.questions.put(pageId, question);
        }
    }
}

