/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuestionCategory;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizAnswersEntity;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.cache.DateFormatterCacheManager;
import com.stiltsoft.confluence.quiz.entity.quiz.QuizParams;
import com.stiltsoft.confluence.quiz.entity.quiz.question.CategoryStats;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionParams;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionStats;
import com.stiltsoft.confluence.quiz.entity.quiz.question.QuestionsStats;
import com.stiltsoft.confluence.quiz.entity.quiz.question.StructuredQuestions;
import com.stiltsoft.confluence.quiz.manager.ConfluenceContentSearcher;
import com.stiltsoft.confluence.quiz.manager.QuizMacroManager;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionStatsHelper {
    private static final Logger log = LoggerFactory.getLogger(QuestionStatsHelper.class);
    private QuizService quizService;
    private QuizMacroManager quizMacroManager;
    private ConfluenceContentSearcher confluenceContentSearcher;
    private DateFormatterCacheManager dateFormatterCacheManager;

    public QuestionStatsHelper(QuizService quizService, QuizMacroManager quizMacroManager, ConfluenceContentSearcher confluenceContentSearcher, DateFormatterCacheManager dateFormatterCacheManager) {
        this.quizService = quizService;
        this.quizMacroManager = quizMacroManager;
        this.confluenceContentSearcher = confluenceContentSearcher;
        this.dateFormatterCacheManager = dateFormatterCacheManager;
    }

    public QuestionsStats getStats(ContentEntityObject ceo, boolean isIndex, String spaceKey) throws MacroExecutionException {
        QuizParams quizParams;
        try {
            quizParams = this.quizMacroManager.getQuizParams(ceo);
        }
        catch (XhtmlException e) {
            throw new MacroExecutionException((Throwable)e);
        }
        QuestionsStats stats = new QuestionsStats();
        StructuredQuestions structuredQuestions = isIndex ? this.confluenceContentSearcher.findStructuredQuestions(quizParams.getLabels(), spaceKey) : this.confluenceContentSearcher.findStructuredQuestions(ceo.getId(), AuthenticatedUserThreadLocal.get());
        DateFormatter dateFormatter = this.dateFormatterCacheManager.getDateFormatter();
        for (QuestionCategory category : structuredQuestions.getCategories()) {
            CategoryStats categoryStats = new CategoryStats(category);
            for (AbstractPage page : structuredQuestions.getQuestions(category)) {
                QuestionParams questionParams;
                List<QuizAnswersEntity> answers = isIndex ? this.quizService.getAnswers(page.getId()) : this.quizService.getAnswers(ceo.getId(), page.getId());
                Iterator<QuizAnswersEntity> iterator = answers.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getCorrect() != null) continue;
                    iterator.remove();
                }
                String created = dateFormatter.formatDateTime(page.getCreationDate());
                try {
                    questionParams = this.quizMacroManager.getQuestionParam((ContentEntityObject)page);
                }
                catch (XhtmlException e) {
                    throw new MacroExecutionException((Throwable)e);
                }
                QuestionStats questionStats = new QuestionStats(page, created, questionParams);
                questionStats.setTotal(answers.size());
                categoryStats.addTotal(answers.size());
                for (QuizAnswersEntity entity : answers) {
                    if (entity.getCorrect().booleanValue()) {
                        questionStats.incSucceeded();
                        categoryStats.incSucceeded();
                    }
                    questionStats.addDuration(entity.getEndTime() - entity.getStartTime());
                    if (entity.getWastedTime() == null) continue;
                    questionStats.addDuration(entity.getWastedTime());
                }
                categoryStats.addDuration(questionStats.getDurationMillis());
                categoryStats.addQuestionStats(questionStats);
                if (!isIndex) continue;
                stats.setQuizzesForQuestion(page.getId(), this.confluenceContentSearcher.findQuizzes(page.getId()));
            }
            stats.addCategory(categoryStats);
        }
        return stats;
    }
}

