/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.stiltsoft.confluence.quiz.entity.Participant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantsHelper {
    private static final Logger log = LoggerFactory.getLogger(ParticipantsHelper.class);
    private UserAccessor userAccessor;
    private GroupManager groupManager;

    public ParticipantsHelper(UserAccessor userAccessor, GroupManager groupManager) {
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
    }

    public Set<ConfluenceUser> getParticipants(List<String> users, List<String> groups, List<String> emails) throws EntityException {
        HashSet<ConfluenceUser> participants = new HashSet<ConfluenceUser>();
        for (String group : groups) {
            for (ConfluenceUser user : this.userAccessor.getMembers(this.groupManager.getGroup(group))) {
                if (this.userAccessor.isDeactivated((com.atlassian.user.User)user)) continue;
                participants.add(user);
            }
        }
        for (String name : users) {
            ConfluenceUser student = this.userAccessor.getUserByName(name);
            if (student == null) continue;
            participants.add(student);
        }
        for (String email : emails) {
            Pager pager = this.userAccessor.getUsersByEmail(email).pager();
            if (pager.isEmpty()) {
                participants.add(new Participant(email));
                continue;
            }
            ConfluenceUser student = this.userAccessor.getUserByName(((User)pager.getCurrentPage().get(0)).getName());
            participants.add(student);
        }
        return participants;
    }
}

