/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.license.License;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseManager {
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private PluginLicenseManager pluginLicenseManager;
    private LicenseService licenseService;

    public LicenseManager(PluginLicenseManager pluginLicenseManager, LicenseService licenseService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseService = licenseService;
    }

    public boolean isActive() {
        License license = com.atlassian.license.LicenseManager.getInstance().getLicense("CONF");
        Boolean isLicenseActive = license != null && license.getLicenseType().getType() == 539;
        try {
            PluginLicense pluginLicense;
            if (this.pluginLicenseManager.getLicense().isDefined() && !(pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                isLicenseActive = true;
            }
        }
        catch (Exception e) {
            log.error("Unable to get license", (Throwable)e);
        }
        return isLicenseActive;
    }

    public boolean isDataCenter() {
        return this.licenseService.isLicensedForDataCenter();
    }
}

