/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.UserEntity;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseAnswers;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseCategory;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseModule;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSection;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseStateEntity;
import com.stiltsoft.confluence.quiz.ao.entity.quiz.QuizStateEntity;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseModuleService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseSettingsService;
import com.stiltsoft.confluence.quiz.ao.service.course.CourseStateEntityService;
import com.stiltsoft.confluence.quiz.ao.service.learning.LearningService;
import com.stiltsoft.confluence.quiz.ao.service.quiz.QuizService;
import com.stiltsoft.confluence.quiz.cache.DateFormatterCacheManager;
import com.stiltsoft.confluence.quiz.entity.course.CourseEnrollWrapper;
import com.stiltsoft.confluence.quiz.entity.course.CourseMetadata;
import com.stiltsoft.confluence.quiz.entity.course.CourseModuleStats;
import com.stiltsoft.confluence.quiz.entity.course.CourseParticipantStats;
import com.stiltsoft.confluence.quiz.entity.course.CourseTreeItem;
import com.stiltsoft.confluence.quiz.entity.course.Student;
import com.stiltsoft.confluence.quiz.entity.course.UserCourse;
import com.stiltsoft.confluence.quiz.entity.quiz.Quiz;
import com.stiltsoft.confluence.quiz.manager.ConfluencePermissionHelper;
import com.stiltsoft.confluence.quiz.manager.UserEntityService;
import com.stiltsoft.confluence.quiz.service.course.CourseMetadataService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseReportHelper {
    private static final Logger log = LoggerFactory.getLogger(CourseReportHelper.class);
    private CourseStateEntityService stateEntityService;
    private CourseModuleService moduleService;
    private QuizService quizService;
    private UserEntityService userEntityService;
    private PageManager pageManager;
    private UserAccessor userAccessor;
    private DateFormatterCacheManager dateFormatterCacheManager;
    private CourseSettingsService settingsService;
    private LearningService learningService;
    private CourseMetadataService courseMetadataService;
    private ConfluencePermissionHelper confluencePermissionHelper;

    public CourseReportHelper(CourseStateEntityService stateEntityService, CourseModuleService moduleService, QuizService quizService, UserEntityService userEntityService, PageManager pageManager, UserAccessor userAccessor, DateFormatterCacheManager dateFormatterCacheManager, CourseSettingsService settingsService, LearningService learningService, CourseMetadataService courseMetadataService, ConfluencePermissionHelper confluencePermissionHelper) {
        this.stateEntityService = stateEntityService;
        this.moduleService = moduleService;
        this.quizService = quizService;
        this.userEntityService = userEntityService;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.dateFormatterCacheManager = dateFormatterCacheManager;
        this.settingsService = settingsService;
        this.learningService = learningService;
        this.courseMetadataService = courseMetadataService;
        this.confluencePermissionHelper = confluencePermissionHelper;
    }

    public List<CourseModuleStats> getModulesStats(long courseId) {
        ArrayList<CourseModuleStats> moduleStats = new ArrayList<CourseModuleStats>();
        for (CourseModule module : this.moduleService.get(courseId)) {
            AbstractPage page = this.pageManager.getAbstractPage(module.getModuleId().longValue());
            if (page == null) {
                this.moduleService.removeTx(courseId, module.getID());
                continue;
            }
            CourseAnswers[] answers = this.stateEntityService.getAnswers(courseId, module.getModuleId());
            CourseModuleStats stats = new CourseModuleStats(module.getModuleId(), page.getTitle(), module.getType());
            for (CourseAnswers answer : answers) {
                if (!answer.getDeleted().booleanValue()) {
                    stats.incTotal();
                }
                if (answer.getProgress() != 2) continue;
                stats.incTotalTries();
                if (!answer.getDeleted().booleanValue() && answer.getPassed().booleanValue()) {
                    stats.incSucceeded();
                }
                stats.addDuration(answer.getWastedTime() + answer.getEndTime() - answer.getStartTime());
            }
            moduleStats.add(stats);
        }
        return moduleStats;
    }

    public List<CourseParticipantStats> getParticipantStats(List<Long> courseIds, List<Integer> studentIds, int start, int limit) {
        if (courseIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CourseParticipantStats> stats = new ArrayList<CourseParticipantStats>();
        HashMap<Long, AbstractPage> pageMap = new HashMap<Long, AbstractPage>();
        Map<Long, CourseSettings> courseSettingsByCourseIds = this.settingsService.getCourseSettingsByCourseIdsMap(courseIds);
        for (CourseEnrollWrapper courseEnrollWrapper : this.stateEntityService.getCourseEnrollWrappers(courseIds, studentIds, start, limit)) {
            CourseSettings courseSettings = courseSettingsByCourseIds.get(courseEnrollWrapper.getCourseId());
            stats.add(this.getStat(courseEnrollWrapper, pageMap, courseSettings, null));
        }
        return stats;
    }

    public CourseParticipantStats getStat(CourseEnrollWrapper courseEnrollWrapper) {
        CourseSettings courseSettings = this.settingsService.getOrCreate(courseEnrollWrapper.getCourseId());
        CourseAnswers[] watchingAnswer = this.stateEntityService.findWatchingAnswer(courseEnrollWrapper.getUserId(), courseEnrollWrapper.getCourseId(), courseEnrollWrapper.getAuthor(), courseEnrollWrapper.getStartDate());
        Long watchingId = watchingAnswer.length > 0 ? watchingAnswer[0].getModuleId() : null;
        return this.getStat(courseEnrollWrapper, new HashMap<Long, AbstractPage>(), courseSettings, watchingId);
    }

    public List<UserCourse> getUserCourses(ConfluenceUser user) throws Exception {
        ArrayList<UserCourse> courses = new ArrayList<UserCourse>();
        if (user == null) {
            return courses;
        }
        String userKey = user.getKey().getStringValue();
        DateFormatter dateFormatter = this.dateFormatterCacheManager.getDateFormatter(user);
        for (CourseEnrollWrapper courseEnrollWrapper : this.stateEntityService.getCourseEnrollWrappersByUser(userKey)) {
            CourseMetadata courseMetadata = this.courseMetadataService.getCourseMetadata(courseEnrollWrapper.getCourseId());
            if (courseMetadata == null) continue;
            CourseModule[] allModules = this.moduleService.getCourseStateInitialModules(Long.valueOf(courseEnrollWrapper.getID()));
            UserCourse userCourse = UserCourse.newBuilder().setDateFormatter(dateFormatter).setCourseMetadata(courseMetadata).setCourseEnrollWrapper(courseEnrollWrapper).setCourseModules(allModules).setUserKey(userKey).build();
            courses.add(userCourse);
        }
        return courses;
    }

    public List<UserCourse> getCourses(@Nullable Integer categoryId) throws Exception {
        ArrayList<UserCourse> courses = new ArrayList<UserCourse>();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String userKey = user != null ? user.getKey().getStringValue() : null;
        DateFormatter dateFormatter = this.dateFormatterCacheManager.getDateFormatter();
        for (Map.Entry<CourseSettings, CourseCategory[]> entry : this.learningService.getAvailableCourses(categoryId).entrySet()) {
            CourseMetadata courseMetadata = this.courseMetadataService.getCourseMetadata(entry.getKey());
            if (courseMetadata == null) continue;
            CourseStateEntity courseStateEntity = user != null ? this.stateEntityService.getLatestActualStates(entry.getKey().getCourseId(), userKey) : null;
            UserCourse course = UserCourse.newBuilder().setDateFormatter(dateFormatter).setCourseMetadata(courseMetadata).setUserKey(userKey).setCourseEnrollWrapper(new CourseEnrollWrapper(courseStateEntity)).setCourseCategories(entry.getValue()).build();
            courses.add(course);
        }
        Collections.sort(courses);
        return courses;
    }

    private CourseParticipantStats getStat(CourseEnrollWrapper courseEnrollWrapper, Map<Long, AbstractPage> pageMap, CourseSettings courseSettings, Long watchingId) {
        DateFormatter dateFormatter = this.dateFormatterCacheManager.getDateFormatter();
        CourseParticipantStats stat = new CourseParticipantStats(courseEnrollWrapper.getID());
        stat.setStatus(courseEnrollWrapper.getStatus());
        stat.setCourseId(courseEnrollWrapper.getCourseId());
        UserEntity userEntity = this.userEntityService.getUser(courseEnrollWrapper.getUserId());
        ConfluenceUser user = null;
        if (!userEntity.getExternal().booleanValue()) {
            user = this.userAccessor.getUserByKey(new UserKey(userEntity.getKey()));
        }
        if (userEntity.getExternal().booleanValue()) {
            stat.setEmail(userEntity.getKey());
            stat.setName(userEntity.getName());
        } else {
            stat.setStudent(new Student(user));
        }
        if (courseEnrollWrapper.wasStarted()) {
            stat.setStartedMs(courseEnrollWrapper.getStartDate());
            stat.setStarted(dateFormatter.formatDateTime(new Date(courseEnrollWrapper.getStartDate())));
            long endTime = courseEnrollWrapper.getStatus() == 2 ? courseEnrollWrapper.getEndDate() : System.currentTimeMillis();
            stat.addDuration(endTime - courseEnrollWrapper.getStartDate());
            if (courseEnrollWrapper.getStatus() == 2 && courseEnrollWrapper.getCompletedDateOpt().isPresent()) {
                long completedDate = courseEnrollWrapper.getCompletedDateOpt().get();
                stat.setCompletedMs(completedDate);
                stat.setCompleted(dateFormatter.formatDateTime(new Date(completedDate)));
            }
        }
        stat.setEnrolledMs(courseEnrollWrapper.getEnrolledDate());
        stat.setEnrolled(dateFormatter.formatDateTime(new Date(courseEnrollWrapper.getEnrolledDate())));
        if (courseEnrollWrapper.getDueDate() != null) {
            stat.setDueDateMs(courseEnrollWrapper.getDueDate());
            stat.setDueDate(dateFormatter.format(new Date(courseEnrollWrapper.getDueDate())));
        }
        stat.setCourseTree(this.getCourseTree(courseEnrollWrapper, pageMap, courseSettings, watchingId));
        int[] moduleTreeStats = this.getModulesStats(stat.getCourseTree());
        stat.setTotal(moduleTreeStats[0]);
        stat.setLeft(moduleTreeStats[1]);
        return stat;
    }

    private List<CourseTreeItem> getCourseTree(CourseEnrollWrapper courseEnrollWrapper, Map<Long, AbstractPage> pageMap, CourseSettings courseSettings, Long watchingId) {
        ArrayList<CourseTreeItem> courseTree = new ArrayList<CourseTreeItem>();
        HashMap<Long, CourseAnswers> answersMap = new HashMap<Long, CourseAnswers>();
        for (CourseAnswers answers : this.stateEntityService.getAnswers(courseEnrollWrapper.getCourseId(), courseEnrollWrapper.getUserId(), courseEnrollWrapper.getStartDate())) {
            answersMap.put(answers.getModuleId(), answers);
        }
        for (CourseSection section : courseEnrollWrapper.getCourseSections()) {
            CourseTreeItem sectionItem = null;
            boolean answeredSection = true;
            boolean currentSection = false;
            if (!StringUtils.defaultString((String)section.getName()).isEmpty()) {
                sectionItem = new CourseTreeItem(section.getName(), Long.valueOf(section.getID()));
                sectionItem.setWatching(false);
                courseTree.add(sectionItem);
            }
            ArrayList<CourseTreeItem> moduleItems = new ArrayList<CourseTreeItem>();
            for (CourseModule module : section.getCourseModules()) {
                boolean locked;
                AbstractPage page;
                if (!pageMap.containsKey(module.getModuleId())) {
                    pageMap.put(module.getModuleId(), this.pageManager.getAbstractPage(module.getModuleId().longValue()));
                }
                if ((page = pageMap.get(module.getModuleId())) == null) {
                    this.moduleService.removeTx(module.getCourseId(), module.getID());
                    continue;
                }
                CourseTreeItem moduleItem = new CourseTreeItem(page.getTitle(), page.getId());
                CourseAnswers answers = (CourseAnswers)answersMap.get(module.getModuleId());
                boolean current = false;
                boolean moduleAnswered = false;
                boolean bl = locked = courseSettings.getOrder() == null || courseSettings.getOrder() == 0;
                if (answers != null) {
                    if (answers.getProgress() == 1) {
                        current = true;
                        locked = false;
                    } else if (answers.getProgress() == 2) {
                        moduleAnswered = true;
                        locked = false;
                    }
                }
                moduleItem.setAnswered(moduleAnswered);
                moduleItem.setCurrent(current);
                moduleItem.setLocked(locked);
                moduleItem.setType(module.getType());
                moduleItem.setWatching(module.getModuleId().equals(watchingId));
                if (sectionItem != null) {
                    sectionItem.setWatching(sectionItem.isWatching() || moduleItem.isWatching());
                }
                if (moduleItem.getType() == 1 && (current || moduleAnswered) && answers != null) {
                    QuizStateEntity quizStateEntity = this.quizService.getStateTx(courseEnrollWrapper.getUserId(), module.getModuleId(), courseEnrollWrapper.getAuthor(), answers.getQuizStateId());
                    if (quizStateEntity != null) {
                        boolean currentUserCanView = this.confluencePermissionHelper.canView(page.getId());
                        moduleItem.setQuiz(new Quiz(quizStateEntity, currentUserCanView));
                    }
                    if (quizStateEntity != null && quizStateEntity.getStatus() == 2) {
                        if (quizStateEntity.getReview() != null && quizStateEntity.getReview() > 0) {
                            moduleItem.setQuizState(CourseTreeItem.QuizState.REVIEW);
                        } else if (quizStateEntity.getCorrect() >= quizStateEntity.getTarget()) {
                            moduleItem.setQuizState(CourseTreeItem.QuizState.SUCCESS);
                        } else if (quizStateEntity.getAttempts() == 0) {
                            moduleItem.setQuizState(CourseTreeItem.QuizState.FAIL);
                        } else if (current) {
                            moduleItem.setQuizState(CourseTreeItem.QuizState.IN_PROGRESS);
                        }
                    } else {
                        moduleItem.setQuizState(CourseTreeItem.QuizState.IN_PROGRESS);
                    }
                }
                moduleItems.add(moduleItem);
                answeredSection = answeredSection && moduleAnswered;
                currentSection = currentSection || current;
            }
            if (sectionItem != null) {
                if (moduleItems.isEmpty()) {
                    courseTree.remove(sectionItem);
                    continue;
                }
                sectionItem.setAnswered(answeredSection);
                sectionItem.setCurrent(currentSection);
                sectionItem.setItems(moduleItems);
                continue;
            }
            courseTree.addAll(moduleItems);
        }
        return courseTree;
    }

    private int[] getModulesStats(List<CourseTreeItem> items) {
        int[] stats = new int[]{0, 0};
        for (CourseTreeItem item : items) {
            if (item.getItems().isEmpty()) {
                stats[0] = stats[0] + 1;
                if (item.isAnswered()) continue;
                stats[1] = stats[1] + 1;
                continue;
            }
            int[] innerStats = this.getModulesStats(item.getItems());
            stats[0] = stats[0] + innerStats[0];
            stats[1] = stats[1] + innerStats[1];
        }
        return stats;
    }
}

