/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.stiltsoft.confluence.quiz.ao.entity.course.CourseSettings;
import com.stiltsoft.confluence.quiz.entity.course.CourseSelfEnrollmentType;
import java.util.ArrayList;
import java.util.List;

public class CourseLearningAccessibilityHelper {
    private UserAccessor userAccessor;
    private PageManager pageManager;

    public CourseLearningAccessibilityHelper(UserAccessor userAccessor, PageManager pageManager) {
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
    }

    public List<CourseSettings> filterBySelfEnrollmentType(CourseSettings[] settings) {
        ArrayList<CourseSettings> filteredSettings = new ArrayList<CourseSettings>();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        for (CourseSettings courseSettings : settings) {
            if (!this.isAvailable(courseSettings, user)) continue;
            filteredSettings.add(courseSettings);
        }
        return filteredSettings;
    }

    public boolean isAvailableForCurrentUser(CourseSettings courseSettings) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.isAvailable(courseSettings, user);
    }

    private boolean isAvailable(CourseSettings courseSettings, ConfluenceUser user) {
        AbstractPage page = this.pageManager.getAbstractPage(courseSettings.getCourseId().longValue());
        if (page != null && !page.isDeleted()) {
            if (CourseSelfEnrollmentType.ANYONE.equals(courseSettings.getSelfEnrollmentType())) {
                return true;
            }
            if (user != null) {
                if (CourseSelfEnrollmentType.LOGGED_IN_USERS.equals(courseSettings.getSelfEnrollmentType())) {
                    return true;
                }
                if (CourseSelfEnrollmentType.SPECIFIC_GROUPS.equals(courseSettings.getSelfEnrollmentType()) && courseSettings.getSelfEnrollmentGroups() != null) {
                    String[] groupNames;
                    for (String name : groupNames = courseSettings.getSelfEnrollmentGroups().split(",")) {
                        Group group = this.userAccessor.getGroup(name);
                        if (group == null || !this.userAccessor.hasMembership(group, (User)user)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

