/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.quiz.manager;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.quiz.ao.entity.settings.Coauthor;
import com.stiltsoft.confluence.quiz.ao.service.settings.CoauthorService;
import java.util.ArrayList;
import java.util.Collections;

public class ContentPermissionHelper {
    private CoauthorService coauthorService;
    private UserAccessor userAccessor;
    private ContentPermissionManager contentPermissionManager;

    public ContentPermissionHelper(CoauthorService coauthorService, UserAccessor userAccessor, ContentPermissionManager contentPermissionManager) {
        this.coauthorService = coauthorService;
        this.userAccessor = userAccessor;
        this.contentPermissionManager = contentPermissionManager;
    }

    public void setContentPermission(ConfluenceUser creator, Page page) {
        ArrayList<ContentPermission> permissions = new ArrayList<ContentPermission>();
        for (Coauthor coauthor : this.coauthorService.getCoauthors()) {
            permissions.add(this.createContentPermission(coauthor));
        }
        ContentPermission creatorPermission = ContentPermission.createUserPermission((String)"View", (ConfluenceUser)creator);
        if (!permissions.contains(creatorPermission)) {
            permissions.add(creatorPermission);
        }
        this.contentPermissionManager.setContentPermissions(Collections.singletonMap("View", permissions), (ContentEntityObject)page);
    }

    private ContentPermission createContentPermission(Coauthor coauthor) {
        if (coauthor.getType() == 0) {
            return ContentPermission.createGroupPermission((String)"View", (String)coauthor.getIdentifier());
        }
        if (coauthor.getType() == 1) {
            ConfluenceUser user = this.userAccessor.getExistingUserByKey(new UserKey(coauthor.getIdentifier()));
            return ContentPermission.createUserPermission((String)"View", (ConfluenceUser)user);
        }
        throw new RuntimeException("WRONG COAUTHOR TYPE!");
    }
}

